% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchor.filter.R
\name{anchor.filter}
\alias{anchor.filter}
\title{Filtering out anchors with low contributions to the projection}
\usage{
anchor.filter(x, lim = 0)
}
\arguments{
\item{x}{a radviz object as produced by \code{\link{do.radviz}}}

\item{lim}{the minimum length of an anchor}
}
\value{
a radviz object as produced by \code{\link{do.radviz}}
}
\description{
Filtering out anchors with low contributions to the projection
}
\details{
When \code{anchor.filter} is a number and type is not Radviz, 
any springs whose length is lower than this number will be filtered out 
of the visualization. This has no effect on the projection itself.
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
plot(rv,anchors.only=FALSE)
new.S <- do.optimFreeviz(x = iris[,das], classes = iris$Species)
new.rv <- do.radviz(iris,new.S)
plot(new.rv,anchors.only=FALSE)
plot(anchor.filter(new.rv,0.2))

}
\author{
Yann Abraham
}
