% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabMzxmlFunctions.R
\name{grabMzxmlMS1}
\alias{grabMzxmlMS1}
\title{Extract the MS1 data from an mzXML nodeset}
\usage{
grabMzxmlMS1(xml_data, file_metadata, rtrange, prefilter, incl_polarity)
}
\arguments{
\item{xml_data}{An `xml2` nodeset, usually created by applying `read_xml` to
an mzXML file.}

\item{file_metadata}{Information about the file used to decode the binary
arrays containing m/z and intensity information.}

\item{rtrange}{A vector of length 2 containing an upper and lower bound on
retention times of interest. Providing a range here can speed up load times
(although not enormously, as the entire file must still be read) and reduce
the final object's size.}

\item{prefilter}{The lowest intensity value of interest, used to reduce file
size (and especially useful for profile mode data with many 0 values)}

\item{incl_polarity}{Boolean determining whether the polarity of the scan
should be returned as a column in the table (positive mode = 1, negative
mode = -1)}
}
\value{
A `data.table` with columns for retention time (rt), m/z (mz),
and intensity (int).
}
\description{
Extract the MS1 data from an mzXML nodeset
}
