% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae_rwnn.R
\name{ae_rwnn}
\alias{ae_rwnn}
\alias{ae_rwnn.formula}
\title{Auto-encoder pre-trained random weight neural networks}
\usage{
ae_rwnn(
  formula,
  data = NULL,
  n_hidden = c(),
  lambda = NULL,
  method = "l1",
  type = NULL,
  control = list()
)

\method{ae_rwnn}{formula}(
  formula,
  data = NULL,
  n_hidden = c(),
  lambda = NULL,
  method = "l1",
  type = NULL,
  control = list()
)
}
\arguments{
\item{formula}{A \link{formula} specifying features and targets used to estimate the parameters of the output-layer.}

\item{data}{A data-set (either a \link{data.frame} or a \link[tibble]{tibble}) used to estimate the parameters of the output-layer.}

\item{n_hidden}{A vector of integers designating the number of neurons in each of the hidden-layers (the length of the list is taken as the number of hidden-layers).}

\item{lambda}{A vector of two penalisation constants used when encoding the hidden-weights and training the output-weights, respectively.}

\item{method}{The penalisation type used for the auto-encoder (either \code{"l1"} or \code{"l2"}).}

\item{type}{A string indicating whether this is a regression or classification problem.}

\item{control}{A list of additional arguments passed to the \link{control_rwnn} function.}
}
\value{
An \link{RWNN-object}.
}
\description{
Set-up and estimate weights of a random weight neural network using an auto-encoder for unsupervised pre-training of the hidden weights.
}
\examples{
n_hidden <- c(20, 15, 10, 5)
lambda <- c(2, 0.01)

## Using L1-norm in the auto-encoder (sparse solution)
m <- ae_rwnn(y ~ ., data = example_data, n_hidden = n_hidden, lambda = lambda, method = "l1")

## Using L2-norm in the auto-encoder (dense solution)
m <- ae_rwnn(y ~ ., data = example_data, n_hidden = n_hidden, lambda = lambda, method = "l2")

}
\references{
Zhang Y., Wu J., Cai Z., Du B., Yu P.S. (2019) "An unsupervised parameter learning model for RVFL neural network." \emph{Neural Networks}, 112, 85-97.
}
