% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zigamma2.R
\name{zigamma2}
\alias{zigamma2}
\alias{dzigamma2}
\alias{pzigamma2}
\alias{rzigamma2}
\title{Zero-inflated and reparameterised gamma distribution}
\usage{
dzigamma2(x, mean = 1, sd = 1, zeroprob = 0, log = FALSE)

pzigamma2(q, mean = 1, sd = 1, zeroprob = 0)

rzigamma2(n, mean = 1, sd = 1, zeroprob = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mean}{mean parameter, must be positive.}

\item{sd}{standard deviation parameter, must be positive.}

\item{zeroprob}{zero-inflation probability between 0 and 1.}

\item{log}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{n}{number of random values to return}
}
\value{
\code{dzigamma2} gives the density, \code{pzigamma2} gives the distribution function, and \code{rzigamma} generates random deviates.
}
\description{
Density, distribution function, and random generation for
the zero-inflated gamma distribution reparameterised in terms of mean and standard deviation.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rzigamma2(1, 2, 1, 0.5)
d <- dzigamma2(x, 2, 1, 0.5)
p <- pzigamma2(x, 2, 1, 0.5)
}
