% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficientFrontier.R
\name{efficientFrontier}
\alias{efficientFrontier}
\title{Markowitz Efficient Frontier}
\usage{
efficientFrontier(
  nsims = 5000,
  x = RTL::fizdiffs \%>\% dplyr::select(date, dplyr::contains("WCS")),
  expectedReturns = NULL
)
}
\arguments{
\item{nsims}{Number of portfolio simulations. Defaults to 5000 \code{numeric}}

\item{x}{List as provided by output of RTL::simMultivariates(). \code{list}}

\item{expectedReturns}{Defaults to NULL using periodic returns means. \code{numeric}}
}
\value{
List of portfolios and chart of efficient frontier \code{list}
}
\description{
Generates random portfolio weights statistics based on absolute returns.
}
\details{
\subsection{Commodities}{

Unlike traditional portfolio management, in commodities many transactions are
with derivatives (futures and swaps) and have zero or low initial investments.
}

\subsection{Return types}{

This function is used for commodities where returns are dollars per units
for real assets e.g. storage tanks, pipelines...Here we measure directly
the periodic return in dollars per contract unit.
}

\subsection{Empirical Finance}{

I would encourage you to pick a commodity futures contract of your choice and draw
a scatter plot of price level versus the daily dollar per unit change as measure
of risk. As a trading analyst or risk manager, then ask yourself about the
implications of using log returns that you then re-apply to current forward
curve level to arrive at a dollar risk measure per units instead of measuring
directly risk in dollars per unit.
}
}
\examples{
\dontrun{
x =  RTL::fizdiffs \%>\% dplyr::select(date, dplyr::contains("WCS"))
efficientFrontier(nsims = 10, x = x, expectedReturns = NULL)
efficientFrontier(nsims = 10, x = x, expectedReturns = c(0.5,0.8,0.9))
}
}
\author{
Philippe Cote
}
