% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTCC_function.R
\name{rtcc2}
\alias{rtcc2}
\title{Clustering signal along an environmental gradient}
\usage{
rtcc2(
  table1,
  table2,
  table3,
  species_abundances,
  trait_col_number,
  min_env_col,
  max_env_col,
  env_var_col,
  h_iteration,
  repetitions,
  model
)
}
\arguments{
\item{table1}{A data frame containing organisms names on the first column and its trait values on the
consecutive ones. It also has to contain two columns with the maximum and the minimum values of the tested
environmental variable where the organisms have been observed.}

\item{table2}{A presence-absence observations table with the organisms names on the first column and the
sample names as consecutive colnames.}

\item{table3}{A dataframe containing sample names on the first column and environmental parameters on the
consecutive ones.}

\item{species_abundances}{A vector containing the relative abundance of the organisms on the whole data set on
the same order as appear on Table 1.}

\item{trait_col_number}{Table 1 column number of the tested trait.}

\item{min_env_col}{Table 1 column number indicating the minimum value of the environmental variable were each
organism has been observed.}

\item{max_env_col}{Table 1 column number indicating the maximum value of the environmental variable were each
organism has been observed.}

\item{env_var_col}{Table 2 column number indicating the tested environmental variable.}

\item{h_iteration}{Number of h-index calculations for computing a confidence interval.}

\item{repetitions}{Number of simulated synthetic communities distributions.}

\item{model}{Model selection. All models build synthetic communities based on the organisms richness of the
observed communities.

- Model 1: organism are selected randomly from the global pool.
- Model 2: organism are selected randomly with a probability based on its relative abundance on the global pool.
- Model 3: organism are selected randomly, but only those whose environmental range includes the value of
the simulated community are elegible.
- Model 4: organism are selected randomly, but only those whose environmental range includes the value of
the simulated community are elegible and the selection probability is based on its relative abundance on the global pool.}
}
\value{
The function returns a dataframe with the maximum of the environmental variable on the remaining
metacommunity after the sequential removal, h-index calculation for each environmental value, and its confidence standard deviation.
}
\description{
For a given trait, this function determines whether the observed trait clustering/overdispersion
on the metacommunity is linked to an environmental gradient. For this, it sequentially remove samples
in decreasing order of the environmental variable and computes at each step the remaining
metacommunity h-index. This index is based on the percentage of samples on a metacommunity
presenting significant trait clustering/overdispersion.
}
\examples{

\donttest{
data(group_information)
data(table_presence_absence)
data(metadata)
rtcc2(group_information, table_presence_absence, metadata, group_information$sums,
9, 12, 13, 2, 100, 100, model = 1)
}

}
