/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.sim;

import java.util.List;
import java.util.Map;
import org.act.rscat.cat.ItemScores;
import org.act.rscat.cat.PassageOrItemEligibilityAtThetaRange;
import org.act.rscat.cat.ThetaEst;
import org.act.rscat.cat.ThetaRange;

public class SimOutput {
    private final String examineeId;
    private final double trueTheta;
    private final List<String> itemsAdministered;
    private final List<ItemScores> itemScoresList;
    private final double initTheta;
    private final ThetaEst finalTheta;
    private final List<PassageOrItemEligibilityAtThetaRange> passageOrItemEligibilityAtThetaRangeList;
    private final List<List<String>> shadowTestList;
    private final List<ThetaEst> thetaEstList;
    private final List<Double> catEngineTimeList;
    private final List<Integer> adaptiveStageList;
    private final List<List<Integer>> passageRowIndexSequences;
    private Map<ThetaRange, Map<String, Double>> itemExposureRates;

    private SimOutput(Builder builder) {
        this.examineeId = builder.examineeId;
        this.trueTheta = builder.trueTheta;
        this.itemsAdministered = builder.itemsAdministered;
        this.itemScoresList = builder.itemScoresList;
        this.initTheta = builder.initTheta;
        this.finalTheta = builder.finalTheta;
        this.passageOrItemEligibilityAtThetaRangeList = builder.passageOrItemEligibilityAtThetaRangeList;
        this.shadowTestList = builder.shadowTestList;
        this.thetaEstList = builder.thetaEstList;
        this.catEngineTimeList = builder.catEngineTimeList;
        this.adaptiveStageList = builder.adaptiveStageList;
        this.passageRowIndexSequences = builder.passageRowIndexSequences;
        this.itemExposureRates = builder.itemExposureRates;
    }

    public String getexamineeId() {
        return this.examineeId;
    }

    public double getTrueTheta() {
        return this.trueTheta;
    }

    public List<String> getItemsAdministered() {
        return this.itemsAdministered;
    }

    public List<ItemScores> getItemScoresList() {
        return this.itemScoresList;
    }

    public double getInitTheta() {
        return this.initTheta;
    }

    public ThetaEst getFinalTheta() {
        return this.finalTheta;
    }

    public List<PassageOrItemEligibilityAtThetaRange> getPassageOrItemEligibilityAtThetaRangeList() {
        return this.passageOrItemEligibilityAtThetaRangeList;
    }

    public List<List<String>> getShadowTestList() {
        return this.shadowTestList;
    }

    public List<ThetaEst> getThetaEstList() {
        return this.thetaEstList;
    }

    public List<Double> getCatEngineTimeList() {
        return this.catEngineTimeList;
    }

    public List<Integer> getAdaptiveStageList() {
        return this.adaptiveStageList;
    }

    public List<List<Integer>> getPassageRowIndexSequences() {
        return this.passageRowIndexSequences;
    }

    public Map<ThetaRange, Map<String, Double>> getItemExposureRates() {
        return this.itemExposureRates;
    }

    public void setItemExposureRates(Map<ThetaRange, Map<String, Double>> itemExposureRates) {
        this.itemExposureRates = itemExposureRates;
    }

    public static class Builder {
        private final String examineeId;
        private final double trueTheta;
        private List<String> itemsAdministered;
        private List<ItemScores> itemScoresList;
        private double initTheta;
        private ThetaEst finalTheta;
        private List<PassageOrItemEligibilityAtThetaRange> passageOrItemEligibilityAtThetaRangeList;
        private List<List<String>> shadowTestList;
        private List<ThetaEst> thetaEstList;
        private List<Double> catEngineTimeList;
        private List<Integer> adaptiveStageList;
        private List<List<Integer>> passageRowIndexSequences;
        private Map<ThetaRange, Map<String, Double>> itemExposureRates;

        public Builder(String examineeId, double trueTheta) {
            this.examineeId = examineeId;
            this.trueTheta = trueTheta;
        }

        public Builder itemsAdministered(List<String> newItemsAdministered) {
            this.itemsAdministered = newItemsAdministered;
            return this;
        }

        public Builder itemScoresList(List<ItemScores> newItemScoresList) {
            this.itemScoresList = newItemScoresList;
            return this;
        }

        public Builder initTheta(double newInitTheta) {
            this.initTheta = newInitTheta;
            return this;
        }

        public Builder finalTheta(ThetaEst newFinalTheta) {
            this.finalTheta = newFinalTheta;
            return this;
        }

        public Builder itemEligibilityList(List<PassageOrItemEligibilityAtThetaRange> newPassageOrItemEligibilityAtThetaRangeList) {
            this.passageOrItemEligibilityAtThetaRangeList = newPassageOrItemEligibilityAtThetaRangeList;
            return this;
        }

        public Builder shadowTestList(List<List<String>> newShadowTestList) {
            this.shadowTestList = newShadowTestList;
            return this;
        }

        public Builder thetaEstList(List<ThetaEst> newThetaEstList) {
            this.thetaEstList = newThetaEstList;
            return this;
        }

        public Builder catEngineTimeList(List<Double> newCatEngineTimeList) {
            this.catEngineTimeList = newCatEngineTimeList;
            return this;
        }

        public Builder adaptiveStageList(List<Integer> newAdaptiveStageList) {
            this.adaptiveStageList = newAdaptiveStageList;
            return this;
        }

        public Builder passageRowIndexSequences(List<List<Integer>> newPassageRowIndexSequences) {
            this.passageRowIndexSequences = newPassageRowIndexSequences;
            return this;
        }

        public SimOutput build() {
            return new SimOutput(this);
        }
    }
}

