# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Fast least squares
#'
#' This functions fits the regression y ~ X using Armadillo \code{solve} function.
#' @param y Vector of outcomes.
#' @param X Matrix of covariates (first column should be 1's)
#' @return \code{List} of regression output with elements \code{coef}, \code{stderr}.
fastLm <- function(y, X) {
    .Call(`_RRI_fastLm`, y, X)
}

#' Fast least squares
#'
#' Fast OLS as in \link{fastLm} but returns only the fitted coefficients.
#'
#' @param y Vector of outcomes.
#' @param X Matrix of covariates (first column should be 1's)
#' @return Vector of coefficients.
OLS_c <- function(y, X) {
    .Call(`_RRI_OLS_c`, y, X)
}

#' Fast least squares with linear constraint
#'
#' This functions fits the regression y ~ X under a linear constraint on the
#' model parameters. The constraint is  \code{Q} * beta = \code{c} where beta
#' are the regression model parameters, and \code{Q, c} are inputs.
#'
#' @param y Vector of outcomes.
#' @param X Matrix of covariates (first column should be 1's)
#' @param bhat Unconstrained OLS-fitted coefficients.
#' @param Q Matrix of linear constraints (k x p).
#' @param c Vector of constraint values (k x 1).
#'
#' @return Vector of fitted OLS coefficients under linear constraint.
#' @seealso Advanced Econometrics (Section 1.4, Takeshi Amemiya, 1985)
restricted_OLS_c <- function(y, X, bhat, Q, c) {
    .Call(`_RRI_restricted_OLS_c`, y, X, bhat, Q, c)
}

#' Residual randomization test
#'
#' Implements the residual randomization test. The hypothesis tested is
#'
#'     H0: lam' beta = lam[1] * beta[1] + ... + lam[p] * beta[p] = lam0.
#'
#' @param y Vector of outcomes (n x 1).
#' @param X Matrix of covariates (n x p). First column should be 1's.
#' @param lam Vector of coefficients in linear H0 (p x 1).
#' @param lam0 Scalar value for linear H0.
#' @param cluster_eps_r A \code{List} with restricted residuals. See \link{get_clustered_eps}.
#' @param use_perm \code{Boolean} flag whether to use permutations within clusters.
#' @param use_sign \code{Boolean} flag whether to use sign flips across clusters.
#' @param num_R Integer of how many randomization values to calculate.
#' @return A \code{List} with the observed test statistic value (\code{tobs}), and the randomization values (\code{tvals})
r_test_c <- function(y, X, lam, lam0, cluster_eps_r, use_perm, use_sign, num_R) {
    .Call(`_RRI_r_test_c`, y, X, lam, lam0, cluster_eps_r, use_perm, use_sign, num_R)
}

