% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvals.R
\name{pval}
\alias{pval}
\title{Compute p-values for \code{RPtest} output}
\usage{
pval(test, test_sim)
}
\arguments{
\item{test}{A numeric vector of test statistics.}

\item{test_sim}{A list of test statisitcs, each component of which is a
numeric vector.}
}
\value{
A single p-value.
}
\description{
Produces p-values given a list of simulated test statistics and the true test
statistic (which may be a vector if it is the output of multiple RP
functions).
}
\details{
In the case where the individual test statistics are vectors, the
  first component of test is compared against the first components of
  \code{test_sim[[1]]}, \code{test_sim[[2]]} etc. and the results of these
  multiple comparisons are combined into a single p-value (see the
  reference). When the lengths of the test statistics differ, the final
  components are first discarded to make all the test statistics have equal
  length.
}
\references{
Shah, R. D., Buhlmann, P. (2017) \emph{Goodness of fit tests for
  high-dimensional linear models} \url{https://rss.onlinelibrary.wiley.com/doi/10.1111/rssb.12234}
}
\seealso{
\code{\link{RPtest}} the output of which this would typically be
  applied to.
}
