% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presto_type.R
\name{presto_type}
\alias{presto_type}
\alias{presto_type.tbl_presto}
\title{Get column type information for a Presto table or query}
\usage{
presto_type(data, ...)

\method{presto_type}{tbl_presto}(data, ...)
}
\arguments{
\item{data}{A \code{tbl_presto} object}

\item{...}{Additional arguments (currently unused)}
}
\value{
A data frame with columns:
\itemize{
\item name: Column name (character)
\item type: R type (character)
\item .presto_type: Presto type as string (character)
}
}
\description{
Returns column type information for a \code{tbl_presto} object, including
Presto types for complex and nested types.
}
\examples{
\dontrun{
# Connect to Presto
con <- DBI::dbConnect(RPresto::Presto(), ...)

# Get column types for a table
tbl(con, "my_table") \%>\%
  presto_type()

# Get column types for a query
tbl(con, "my_table") \%>\%
  dplyr::filter(id > 100) \%>\%
  presto_type()
}
}
