% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ciROC.R
\name{plot.rocci}
\alias{plot.rocci}
\title{Plot ROC Curve with confidence limits}
\usage{
\method{plot}{rocci}(
  x,
  col = c("#2F4F4F", "#404040"),
  lty = c(1, 2),
  lwd = c(2, 1),
  grid = TRUE,
  legend = TRUE,
  legendpos = "bottomright",
  ... = NULL
)
}
\arguments{
\item{x}{An object of class \code{"rocci"},
returned by \code{\link{ciROC.rocit}} function.}

\item{col}{Color(s) to be used for the plot. First two colors are used
for the ROC curve and confidence limits if multiple colors supplied. Same
color is used if single color supplied.}

\item{lty}{The line type. Same as in \code{\link{par}}. First two or one are
used (like \code{col}) depending on the length of \code{lty}.}

\item{lwd}{The line width. Same as in \code{\link{par}}. First two or one are
used (like \code{col}) depending on the length of \code{lwd}.}

\item{grid}{Logical, indicating whether to add rectangular grid. Calls
\code{\link{grid}} with default settings.}

\item{legend}{Logical, indicating whether to add legends to the plot.}

\item{legendpos}{Position of the legend. A single keyword from
\code{"bottomright"}, \code{"bottom"},
\code{"bottomleft"}, \code{"left"}, \code{"topleft"},
\code{"top"}, \code{"topright"}, \code{"right"} and \code{"center"},
as in \code{\link[graphics]{legend}}. Ignored if
\code{legend} is \code{FALSE}.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\description{
This function plots  receiver operating
characteristic (ROC) curve with confidence limits.
This is an S3 method for object of class
\code{"rocci"}, returned by \code{\link{ciROC.rocit}} function.
}
\examples{
score <- c(rnorm(300,30,15), rnorm(300,50,15))
class <- c(rep(0,300), rep(1,300))
rocit_object <- rocit(score = score, class = class, method = "bi")
rocci_object <- ciROC(rocit_object)
# ---------------------------
plot(rocci_object)
plot(rocci_object, col = c(2,4))
plot(rocci_object, col = c(2,4), legendpos = "bottom", lty = c(1,3))


}
\seealso{
\code{\link{ciROC}}, \code{\link{rocit}}, \code{\link{plot.rocit}}
}
