% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmm.R
\name{rmm}
\alias{rmm}
\title{Fitting Revenue Management Models}
\usage{
rmm(rmm_data, prop = 0.7, model = "cl")
}
\arguments{
\item{rmm_data}{an object of class "rmm_data", a output of \code{\link{rmm_reshape}} function.}

\item{prop}{numeric, user assumed market share.}

\item{model}{character, specify fitting method ("cl" or "ml"). "cl" (default) refers to the Conditional Logit Model, and "ml" refers to the Multinomial Logit Model.}
}
\value{
\code{\link{rmm}} returns an object of class inheriting from "rmm".
}
\description{
\code{\link{rmm}} is used to fit Revenue Management Models. Users can specify
cl (conditional logit model) and ml (multinomial logit model) as RMM model.
}
\examples{
\donttest{
data(Hotel_Long)

# Before using the rmm function, the user must first use the rmm_shape function.
rst_reshape <- rmm_reshape(data=Hotel_Long, idvar="Booking_ID", alts="Room_Type",
                           asv="Price", resp="Purchase", min_obs=30)

# Fitting a model
rst_rmm <- rmm(rst_reshape, prop=0.7, model="cl")
print(rst_rmm)
}
}
\seealso{
\code{rmm} fits the model with the RDE method introduced in \url{doi:10.2139/ssrn.3598259}.
}
