% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VIKOR.R
\name{apply.VIKOR}
\alias{apply.VIKOR}
\title{Function for applying VIKOR to data}
\usage{
apply.VIKOR(A, weights, nu = 0.5)
}
\arguments{
\item{A}{the comparison matrix}

\item{weights}{the weights of criteria}

\item{nu}{weight of the maximum utility strategy - set by default to 0.5}
}
\value{
a list containing the names of Qi followed by values of Qi, Si, Ri,
condition 1, and condition 2.
}
\description{
Function for applying VIKOR to data
}
\examples{
A <- matrix(c(250, 200, 300, 275,
 225, 16, 16, 32,
  32, 16, 12, 8,
   16, 8, 16, 5,
    3, 4, 4, 2), nrow=5, ncol=4)
colnames(A)<-c("Price", "Memory", "Camera", "Looks")
rownames(A)<-paste0("Mobile ", seq(1, 5, 1))
A[,"Price"] <- -A[,"Price"]
apply.VIKOR(A, c(0.35, 0.3, 0.2, 0.15))
}
