% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_MC_ISO_DELOC.R
\encoding{UTF-8}
\name{run_MC_ISO_DELOC}
\alias{run_MC_ISO_DELOC}
\title{Run Monte-Carlo Simulation for ISO-TL (delocalized transitions)}
\usage{
run_MC_ISO_DELOC(
  s,
  E,
  T = 20,
  times,
  clusters = 10,
  N_e = 200,
  n_filled = N_e,
  R,
  method = "par",
  output = "signal",
  ...
)
}
\arguments{
\item{s}{\link{numeric} (\strong{required}): The frequency factor of the trap (s^-1)}

\item{E}{\link{numeric} (\strong{required}): Thermal activation energy of the trap (eV)}

\item{T}{\link{numeric} (\emph{with default}): Constant stimulation temperature (°C)}

\item{times}{\link{numeric} (\emph{with default}): The sequence of time steps within the simulation (s)}

\item{clusters}{\link{numeric} (\emph{with default}): The number of created clusters for the MC runs. The input can be the output of \link{create_ClusterSystem}. In that case \code{n_filled} indicate absolute numbers of a system.}

\item{N_e}{\link{integer} (\emph{with default}): The total number of electron traps available (dimensionless). Can be a vector of \code{length(clusters)}, shorter values are recycled.}

\item{n_filled}{\link{integer} (\emph{with default}): The number of filled electron traps at the
beginning of the simulation (dimensionless). Can be a vector of \code{length(clusters)}, shorter values are recycled.}

\item{R}{\link{numeric} (\strong{required}): The delocalized retrapping ratio (dimensionless)}

\item{method}{\link{character} (\emph{with default}): Sequential \code{'seq'} or parallel \code{'par'}processing. In
the parallel mode the function tries to run the simulation on multiple CPU cores (if available) with
a positive effect on the computation time.}

\item{output}{\link{character} (\emph{with default}): Output is either the \code{'signal'} (the default) or
\code{'remaining_e'} (the remaining charges, electrons, in the trap)}

\item{\dots}{further arguments, such as \code{cores} to control the number of used CPU cores or \code{verbose} to silence the terminal}
}
\value{
This function returns an object of class \code{RLumCarlo_Model_Output} which
is a \link{list} consisting of an \link{array} with dimension length(times) x clusters
and a \link{numeric} time vector.
}
\description{
Runs a Monte-Carlo (MC) simulation of isothermally stimulated luminescence
(ISO-TL or ITL) using the one trap one recombination centre (OTOR) model.
Delocalised refers to involvement of the conduction band.
}
\details{
\strong{The model}

\deqn{
I_{DELOC}(t) = -dn/dt = (s * exp(-E/(k_{B} * T_{ISO}))) * (n^2 / (N*R + n(1-R)))
}

Where in the function: \cr
t := time \cr
\eqn{k_{B}} := Boltzmann constant (8.617 x 10^-5 eV K^-1) \cr
\eqn{T_{ISO}} = temperature of the isothermal experiment (°C) \cr
n := \code{n_filled}, the number of filled electron traps at the beginning of the simulation\cr
E := the trap depth (eV) \cr
s := the frequency factor in (s^-1) \cr
N := \code{N_e}, the total number of electron traps available (dimensionless) \cr
R := the retrapping ratio for delocalized transitions
}
\section{Function version}{
 0.1.0
}

\examples{
run_MC_ISO_DELOC(
 s = 3.5e12,
 E = 1.45,
 T = 200,
 R = 1,
 method = 'seq',
 times = 0:100) \%>\%
plot_RLumCarlo(legend = TRUE)

} 

\section{How to cite}{
Kreutzer, S., 2025. run_MC_ISO_DELOC(): Run Monte-Carlo Simulation for ISO-TL (delocalized transitions). Function version 0.1.0. In: Friedrich, J., Kreutzer, S., Pagonis, V., Schmidt, C., 2025. RLumCarlo: Monte-Carlo Methods for Simulating Luminescence Phenomena. R package version 0.1.10. https://r-lum.github.io/RLumCarlo/
}

\references{
Pagonis, V., Friedrich, J., Discher, M., Müller-Kirschbaum, A., Schlosser, V.,
Kreutzer, S., Chen, R. and Schmidt, C., 2019. Excited state luminescence signals
from a random distribution of defects: A new Monte Carlo simulation approach for feldspar.
Journal of Luminescence 207, 266–272. \doi{10.1016/j.jlumin.2018.11.024}

\strong{Further reading}

Chen, R., McKeever, S.W.S., 1997. Theory of Thermoluminescence and Related Phenomena.
WORLD SCIENTIFIC. \doi{10.1142/2781}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
}
\keyword{data}
\keyword{models}
