% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsPowerGivenJK.R
\name{SsPowerGivenJKOrVarCom}
\alias{SsPowerGivenJKOrVarCom}
\title{Power given J, K and Obuchowski-Rockette variance components}
\usage{
SsPowerGivenJKOrVarCom(
  J,
  K,
  KStar,
  effectSize,
  VarTR,
  Cov1,
  Cov2,
  Cov3,
  Var,
  alpha = 0.05,
  analysisOption = "RRRC"
)
}
\arguments{
\item{J}{The number of readers in the \strong{pivotal} study}

\item{K}{The number of cases in the \strong{pivotal} study}

\item{KStar}{The number of cases in the \strong{pilot} study}

\item{effectSize}{The effect size}

\item{VarTR}{The treatment-reader OR variance component}

\item{Cov1}{The OR Cov1 covariance}

\item{Cov2}{The OR Cov2 covariance}

\item{Cov3}{The OR Cov3 covariance}

\item{Var}{The OR pure variance term}

\item{alpha}{The size of the test (default = 0.05)}

\item{analysisOption}{The desired generalization ("RRRC", "FRRC", "RRFC", "ALL")}
}
\value{
A list object containing the estimated power and associated statistics
   for each desired generalization.
}
\description{
Power given J, K and Obuchowski-Rockette variance components
}
\details{
The variance components are obtained using \link{StSignificanceTesting} 
    with \code{method = "OR"}.
}
\examples{
dataset <- dataset02 ## the pilot study
KStar <- length(dataset$ratings$NL[1,1,,1])
VarCom <- StSignificanceTesting(dataset, FOM = "Wilcoxon", 
method = "OR", analysisOption = "RRRC")$ANOVA$VarCom
VarTR <- VarCom["VarTR",1]
Cov1 <- VarCom["Cov1",1]
Cov2 <- VarCom["Cov2",1]
Cov3 <- VarCom["Cov3",1]
Var <- VarCom["Var",1]
ret <- SsPowerGivenJKOrVarCom (J = 5, K = 100, KStar = KStar,  
   effectSize = 0.05, VarTR, Cov1, Cov2, Cov3, Var, analysisOption = "RRRC")
    
cat("RRRC power = ", ret$powerRRRC)

}
