/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataIterator;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsObservation;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Enumeration;

public final class TsDataBlock {
    public final DataBlock data;
    public final TsPeriod start;

    public static TsDataBlock fullYears(TsData series) {
        TsPeriod start = series.getStart();
        TsPeriod end = series.getEnd();
        int freq = series.getFrequency().intValue();
        int nbeg = start.getPosition();
        if (nbeg != 0) {
            nbeg = freq - nbeg;
        }
        int nend = end.getPosition();
        return new TsDataBlock(series, nbeg, series.getLength() - nend, 1);
    }

    public static TsDataBlock select(TsData series, TsDomain domain) {
        if (!series.getDomain().contains(domain)) {
            return null;
        }
        TsPeriod start = series.getStart();
        TsPeriod dstart = domain.getStart();
        int istart = dstart.minus(start);
        return new TsDataBlock(series, istart, istart + domain.getLength(), 1);
    }

    public static TsDataBlock select(TsData series, TsPeriodSelector selector) {
        TsDomain domain = series.getDomain().select(selector);
        if (domain == null || domain.isEmpty()) {
            return null;
        }
        TsPeriod start = series.getStart();
        TsPeriod dstart = domain.getStart();
        int istart = dstart.minus(start);
        return new TsDataBlock(series, istart, istart + domain.getLength(), 1);
    }

    public static TsDataBlock select(TsDataBlock data, int start, int count, int inc) {
        TsPeriod pstart = data.start.plus(start * data.data.getIncrement());
        return new TsDataBlock(pstart, data.data.extract(start, count, inc));
    }

    public static TsDataBlock all(TsData series) {
        return new TsDataBlock(series.getStart(), new DataBlock(series.internalStorage()));
    }

    public Enumeration<TsObservation> observations() {
        return new TsDataIterator(this);
    }

    public TsPeriod period(int i) {
        return this.start.plus(this.data.getIncrement() * i);
    }

    TsDataBlock(TsData series, int start, int end, int inc) {
        this.data = new DataBlock(series.internalStorage(), start, end, inc);
        this.start = series.getStart().plus(start);
    }

    TsDataBlock(TsPeriod start, DataBlock data) {
        this.data = data;
        this.start = start;
    }

    TsDataBlock drop(int nbeg, int nend) {
        return new TsDataBlock(this.start.plus(nbeg * this.data.getIncrement()), this.data.drop(nbeg, nend));
    }

    TsDataBlock extend(int nbeg, int nend) {
        return new TsDataBlock(this.start.minus(nbeg * this.data.getIncrement()), this.data.extend(nbeg, nend));
    }

    void move(int m) {
        if (m == 0) {
            return;
        }
        this.start.move(m);
        this.data.slide(m);
    }
}

