/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.bfgs;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.realfunctions.FunctionException;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.bfgs.ILineFunction;

public class DefaultLineFunction
implements ILineFunction {
    private IFunction m_fn;
    private IFunctionInstance m_ftry;
    private DataBlock m_ptmp;
    private DataBlock m_origin;
    private DataBlock m_dir;
    private double m_step;
    private double m_max = 1.0;
    private double m_dstep1 = 8.0;
    private double m_dstep2 = 1.05;
    private double m_df;
    private int m_maxiter = 100;

    public DefaultLineFunction(IFunction fn, IFunctionInstance point, double[] dir, double[] grad) {
        this.m_fn = fn;
        this.m_ftry = point;
        this.m_ptmp = new DataBlock(point.getParameters());
        this.m_origin = new DataBlock(this.m_ptmp);
        this.m_dir = new DataBlock((double[])dir.clone());
        if (grad != null) {
            this.m_df = this.m_dir.dot(new DataBlock(grad));
        }
        this.calcMax();
    }

    private double calcEpsilon() {
        double eps = 0.0;
        for (int i = 0; i < this.m_dir.getLength(); ++i) {
            double di = Math.abs(this.m_dir.get(i));
            if (di == 0.0) continue;
            double e = this.m_fn.getDomain().epsilon(this.m_ftry.getParameters(), i) / di;
            if (eps != 0.0 && !(eps > e)) continue;
            eps = e;
        }
        return eps;
    }

    private void calcMax() {
        this.m_max = 1.0;
        if (this.calcp(this.m_max)) {
            this.m_max = this.expand(this.m_max, this.m_dstep1, false);
            this.m_max = this.expand(this.m_max, 1.0 / this.m_dstep2, true);
        } else {
            this.m_max = this.expand(this.m_max, 1.0 / this.m_dstep1, true);
            if (this.m_max != 0.0) {
                this.m_max = this.expand(this.m_max, this.m_dstep2, false);
                this.m_max /= this.m_dstep2;
            }
        }
    }

    private boolean calcp(double alpha) {
        this.m_ptmp.copy(this.m_origin);
        this.m_ptmp.addAY(alpha, this.m_dir);
        return this.m_fn.getDomain().checkBoundaries(this.m_ptmp);
    }

    private double expand(double val, double factor, boolean test) {
        int iter = 0;
        if (test) {
            while (!this.calcp(val *= factor) && iter++ < this.m_maxiter) {
            }
        } else {
            while (this.calcp((val *= factor) * factor) && iter++ < this.m_maxiter) {
            }
        }
        if (test && iter == this.m_maxiter) {
            if (factor <= 1.0) {
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        return val;
    }

    @Override
    public double getDerivative() {
        if (this.m_df != 0.0) {
            return this.m_df;
        }
        double eps = this.calcEpsilon();
        for (int n = 10; n >= 0; --n) {
            if (this.calcp(this.m_step + eps)) {
                this.m_df = (this.m_fn.evaluate(this.m_ptmp).getValue() - this.m_ftry.getValue()) / eps;
                return this.m_df;
            }
            if (this.calcp(this.m_step - eps)) {
                this.m_df = (this.m_ftry.getValue() - this.m_fn.evaluate(this.m_ptmp).getValue()) / eps;
                return this.m_df;
            }
            eps /= 2.0;
        }
        throw new FunctionException("Error in computing derivatives");
    }

    public IFunctionInstance getResult() {
        return this.m_ftry;
    }

    @Override
    public double getStep() {
        return this.m_step;
    }

    @Override
    public double getStepMax() {
        return this.m_max;
    }

    @Override
    public double getStepMin() {
        return 0.0;
    }

    @Override
    public double getValue() {
        return this.m_ftry.getValue();
    }

    @Override
    public void setStep(double value) {
        if (value == this.m_step) {
            return;
        }
        if (value < 0.0 || value > this.m_max || !this.calcp(value)) {
            throw new FunctionException("Error in computing optimization step");
        }
        this.m_step = value;
        this.m_ftry = this.m_fn.evaluate(this.m_ptmp);
        this.m_df = 0.0;
    }
}

