% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microbenchmark_sparse_matrix_kernel.R
\name{MicrobenchmarkSparseMatrixKernel}
\alias{MicrobenchmarkSparseMatrixKernel}
\title{Performs microbenchmarking of a sparse matrix linear algebra kernel}
\usage{
MicrobenchmarkSparseMatrixKernel(benchmarkParameters, numberOfThreads,
  resultsDirectory, runIdentifier)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{SparseMatrixMicrobenchmark}} specifying the matrix
dimensions of matrices to be tested and the number of performance trials
to perform for each matrix dimension.}

\item{numberOfThreads}{the number of threads the microbenchmark is being
performed with.  The value is for informational purposes only and does not
effect the number threads the kernel is executed with.}

\item{resultsDirectory}{a character string specifying the directory
where all of the CSV performance results files will be saved}

\item{runIdentifier}{a character string specifying the suffix to be
appended to the base of the file name of the output CSV format files}
}
\value{
a dataframe containing the performance trial times for each matrix
  tested, that is the raw performance data before averaging.  The columns
  of the data frame are the following:
  \describe{
    \item{BenchmarkName}{The name of the microbenchmark}
    \item{NumberOfRows}{An integer specifying the expected number of rows in
      the input sparse matrix}
    \item{NumberOfColumns}{An integer specifying the expected number of
      columns in the input sparse matrix}
    \item{UserTime}{The amount of time spent in user-mode code within the
      microbenchmarked code}
    \item{SystemTime}{The amount of time spent in the kernel within the
      process}
    \item{WallClockTime}{The total time spent to complete the performance
      trial}
    \item{DateStarted}{The date and time the performance trial was commenced}
    \item{DateFinished}{The date and time the performance trial ended}
  }
}
\description{
\code{MicrobenchmarkSparseMatrixKernel} performs microbenchmarking of a
sparse matrix linear algebra kernel for several matrix dimensions
}
\details{
This function performs microbenchmarking of a sparse matrix linear algebra
kernel for several matrix dimensions and a given number of threads.  The
kernel to be performance tested, the matrix dimensions to be tested, and
other parameters specifying how the kernel is to be benchmarked are given in
the input object \code{benchmarkParameters} which is an instance of
the class \code{\link{SparseMatrixMicrobenchmark}}.
For each matrix dimension to be tested, the run time performance of the
kernel is averaged over multiple runs.  The kernel can also be executed with
multiple threads if the kernel supports multithreading.
See \code{\link{SparseMatrixMicrobenchmark}}
for more details on the benchmarking parameters.
}
