% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dense_matrix_kernels.R
\name{CholeskyAllocator}
\alias{CholeskyAllocator}
\title{Allocates and initializes input to the Cholesky factorization dense matrix
kernel microbenchmarks}
\usage{
CholeskyAllocator(benchmarkParameters, index)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{DenseMatrixMicrobenchmark}} specifying various parameters
needed to generate input for the dense matrix kernel.}

\item{index}{an integer index indicating the dimensions of the matrix or
vector data to be generated as input for the dense matrix kernel.}
}
\value{
a list containing the matrices or vectors to be input for the
  dense matrix kernel for which a single performance trial is to be
  conducted.
}
\description{
\code{CholeskyAllocator} allocates and populates the input to the
Cholesky factorization dense matrix kernel for the purposes of conducting a
single performance trial with the \code{CholeskyMicrobenchmark} function.
The matrices or vectors corresponding to the \code{index} parameter must be
allocated, populated and returned in the \code{kernelParameters} list.
}
