% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gspaceMethods.R
\docType{methods}
\name{plotGraphSpace,GraphSpace-method}
\alias{plotGraphSpace,GraphSpace-method}
\alias{plotGraphSpace}
\alias{plotGraphSpace,igraph-method}
\title{Plotting igraph objects with RGraphSpace}
\usage{
\S4method{plotGraphSpace}{GraphSpace}(
  gs,
  theme = c("th0", "th1", "th2", "th3"),
  xlab = "Graph coordinates 1",
  ylab = "Graph coordinates 2",
  font.size = 1,
  bg.color = "grey95",
  add.labels = FALSE,
  node.labels = NULL,
  label.size = 3,
  label.color = "grey20",
  add.image = FALSE,
  raster = FALSE,
  dpi = 300,
  dev = "cairo_png"
)

\S4method{plotGraphSpace}{igraph}(gs, ..., mar = 0.1)
}
\arguments{
\item{gs}{Either an \code{igraph} or \linkS4class{GraphSpace} class object.
If \code{gs} is an \code{igraph}, then it must include \code{x}, \code{y}, 
and \code{name}  vertex attributes (see \code{\link{GraphSpace}}).}

\item{theme}{Name of a custom RGraphSpace theme. These themes 
(from 'th1' to 'th3') consist of preconfigured ggplot settings, 
which the user can subsequently refine using \code{\link[ggplot2]{ggplot2}}.}

\item{xlab}{The title for the 'x' axis of a 2D-image space.}

\item{ylab}{The title for the 'y' axis of a 2D-image space.}

\item{font.size}{A single numeric value passed to ggplot themes.}

\item{bg.color}{A single color for background.}

\item{add.labels}{A logical value indicating whether to plot vertex labels.}

\item{node.labels}{A vector of vertex names to be highlighted in the graph
space. This argument overrides 'add.labels'.}

\item{label.size}{A size argument passed to \code{\link[ggplot2]{geom_text}}.}

\item{label.color}{A color passed to \code{\link[ggplot2]{geom_text}}.}

\item{add.image}{A logical value indicating whether to add a background 
image, when one is available (see \code{\link{GraphSpace}}).}

\item{raster}{A logical value indicating whether to rasterize the main plot.
See \code{\link[ggrastr]{rasterise}} for further specifications.}

\item{dpi}{Raster resolution, in dots per inch.}

\item{dev}{Device used in the \code{\link[ggrastr]{rasterise}} call.}

\item{...}{Additional arguments passed to the 
\code{\link{plotGraphSpace}} function.}

\item{mar}{A single numeric value (in \code{[0,1]}) indicating the size of
the outer margins as a fraction of the graph space.}
}
\value{
A ggplot-class object.
}
\description{
\code{plotGraphSpace} is a wrapper function to 
create dedicated ggplot graphics for igraph- and GraphSpace-class objects.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

# Generate a ggplot for igraph
plotGraphSpace(gtoy1)

# Create a GraphSpace object
gs <- GraphSpace(gtoy1)

# Generate a ggplot for gs
plotGraphSpace(gs)

}
\seealso{
\code{\link{GraphSpace}}
}
\author{
Sysbiolab.
}
