% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gspaceMisc.R
\name{make_gspace_legend}
\alias{make_gspace_legend}
\alias{add_gspace_legend}
\title{Create standalone legends for RGraphSpace's ggplot objects}
\usage{
make_gspace_legend(
  color_palette,
  breaks = NULL,
  legend_title = "Title",
  legend_shape = 21,
  legend_size = 6,
  text_size = 10,
  orientation = c("vertical", "horizontal"),
  justification = c("left", "right"),
  custom_theme = theme()
)

add_gspace_legend(
  plot,
  legend,
  spacer = unit(2, "mm"),
  position = c("right", "top", "bottom", "left")
)
}
\arguments{
\item{color_palette}{A named character vector of colors. Names become 
legend labels. Values must be valid R color specifications, e.g. 
`color_palette = c(A = "#FF0000", B = "blue")`.}

\item{breaks}{A vector indicating numeric breaks for a continuous legend. 
If missing, `color_palette` will instead produce a discrete legend.}

\item{legend_title}{The legend title.}

\item{legend_shape}{Point shape (default 21, for circle).}

\item{legend_size}{Size of legend points (default 6 mm).}

\item{text_size}{Text size (default 10 mm).}

\item{orientation}{Legend arrangement ("vertical" or "horizontal").}

\item{justification}{Legend justification within bounding box 
("left" or "right").}

\item{custom_theme}{An optional `ggplot2` theme object applied to the
legend panel. This allows customizing the appearance of the legend without
affecting the main plot.}

\item{plot}{A GraphSpace plot.}

\item{legend}{A list with multiple `gspace` legends.}

\item{spacer}{A grid::unit() value specifying space inserted between 
merged legends.}

\item{position}{Placement of legend relative to the main plot.}
}
\value{
The `make_gspace_legend()` function returns a standalone legend, while the
`add_gspace_legend()` function returns a patchwork object containing a plot
combined with the generated legend in the specified position.
}
\description{
This accessor builds a standalone legend from a named vector of colors. The 
resulting legend is returned as a 'grob' object that can be used to add 
external legends to existing ggplots.
}
\details{
The object returned by `add_gspace_legend()` behaves like a ggplot for saving,
combining with patchwork, arranging in grids, and rendering in standard
graphics devices. Internally, however, the original ggplot is converted into
a static 'grob' embedded inside a blank ggplot. As a result, the returned 
object cannot accept new layers, scales, or other ggplot modifications; it 
is no longer an editable ggplot, but a wrapped graphical representation 
of the composed figure.
}
\examples{
library(ggplot2)
library(patchwork)

p <- ggplot(mtcars, aes(wt, mpg)) + geom_point()

# Add a discrete standalone legend to a plot
leg1 <- make_gspace_legend(c(A="red", B="blue"), legend_size = 5)
p + leg1 + plot_layout(widths = c(1, 0.1))

# Add a continuous standalone legend to a plot
leg2 <- make_gspace_legend(c("blue", "white","red"), breaks = c(0, 1, 2))
p + leg2 + plot_layout(widths = c(1, 0.1))

# Add a legend list to a plot
legs <- list(leg1, leg2)
add_gspace_legend(plot = p, legs, position = "right")

}
