% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gspaceGeom.R
\name{geom_nodespace}
\alias{geom_nodespace}
\title{Draw node elements in a 2D graph layout}
\usage{
geom_nodespace(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by [ggplot2::aes()].
These mappings apply to the layer and may override global aesthetics.}

\item{data}{Either a \linkS4class{GraphSpace} object or a data frame 
containing node attributes. If `NULL`, the layer will use the default 
plot data.}

\item{stat}{The statistical transformation to use on the data.
Defaults to `"identity"`.}

\item{position}{Position adjustment, either as a string or
the result of a call to a position adjustment function.}

\item{...}{Additional parameters passed to the underlying
drawing function in `GeomNodeSpace`.}

\item{na.rm}{Logical. Should missing values be removed?
Defaults to `TRUE`.}

\item{show.legend}{Logical or a named logical vector indicating
whether this layer should be included in legends.}

\item{inherit.aes}{Logical. If `FALSE` (default), the layer will use 
aesthetics defined in `mapping`. Set to `TRUE` if this geom should 
inherit aesthetics from the plot.}
}
\value{
A ggplot2 layer that renders node glyphs defined by
`GeomNodeSpace`.
}
\description{
Constructor for \code{\link{GeomNodeSpace}} ggproto objects, a variant 
of \code{\link[ggplot2]{geom_point}} supporting node attributes from 
\linkS4class{GraphSpace} objects.

This geom is designed to create node-level aesthetics such as
`size`, `fill`, `colour`, or any custom aesthetics 
defined in `GeomNodeSpace`.
}
\section{Aesthetics}{


`geom_nodespace` understands the following aesthetics:

\itemize{
  \item `x` Horizontal position in `npc` \code{\link[grid]{unit}} (required).
  \item `y` Vertical position in `npc` \code{\link[grid]{unit}} (required).
  \item `size` Node size in `npc` \code{\link[grid]{unit}} (required).
  \item `fill` Node fill colour.
  \item `colour` Node line colour.
  \item `shape` Integer code between 0 and 25 
  (see \code{\link[graphics]{points}}).
  \item `linewidth` Line width, using 'lwd' standard graphics unit 
  (see \code{\link[grid]{gpar}}).
  \item `alpha` Transparency applied to fill and line colour.
}
}

\examples{

# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

# Create a GraphSpace object
gs <- GraphSpace(gtoy1)

\dontrun{

ggplot() + geom_nodespace(aes(x = x, y = y), data = gs)

}

}
\seealso{
\code{\link{GeomNodeSpace}}, \linkS4class{GraphSpace}
}
