% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode_knn.R
\name{decode_knn}
\alias{decode_knn}
\title{Decode RF Embeddings}
\usage{
decode_knn(rf, emap, z, x_tilde = NULL, k = 5, parallel = TRUE)
}
\arguments{
\item{rf}{Pre-trained random forest object of class \code{ranger}.}

\item{emap}{Spectral embedding learned via \code{eigenmap}.}

\item{z}{Matrix of embedded data to map back to the input space.}

\item{x_tilde}{Supplied training data, if none supplied then the RF is used
to generate synthetic training data according to the eForest scheme. Default
is NULL.}

\item{k}{Number of nearest neighbors to evaluate.}

\item{parallel}{Compute in parallel? Must register backend beforehand, e.g.
via \code{doParallel}.}
}
\value{
Decoded dataset.
}
\description{
Maps the low-dimensional KPCA embedding of a random forest back to the input
space via iterative k-nearest neighbors.
}
\details{
\code{decode_knn} decodes the embedded data back to the original input space
using a k-nearest neighbors (kNN) (Cover & Hart, 1967) approach. For a given
embedding vector, decoding works by first finding the k nearest embeddings
within the training set. Then, \code{x_tilde} is either supplied or generated
from the RF (if generated, using the 'eForest' scheme (Feng & Zhou, 2018)),
which provides a proxy for the training samples associated with these
embeddings, to avoid needing to retain training data. Finally, data is
reconstructed by weighted averaging for numerical features, and the most
likely value for categorical features.
}
\examples{
# Set seed
set.seed(1)

# Split training and test
trn <- sample(1:nrow(iris), 100)
tst <- setdiff(1:nrow(iris), trn)

# Train RF, learn the encodings and project test points.
rf <- ranger::ranger(Species ~ ., data = iris[trn, ], num.trees=50)
emap <- encode(rf, iris[trn, ], k=2)
emb <- predict(emap, rf, iris[tst, ])

# Decode test samples back to the input space
out <- decode_knn(rf, emap, emb, k=5)$x_hat

}
\references{
Cover, T., & Hart, P. (1967). Nearest neighbor pattern classification.
\emph{IEEE Transactions on Information Theory, 13}(1), 21–27.

Feng, J., & Zhou, Z. H. (2018, April). Autoencoder by forest. In
\emph{Proceedings of the AAAI conference on artificial intelligence} (Vol. 32
, No. 1).
}
