% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ren.R
\name{ren}
\alias{ren}
\title{Main Function for Portfolio Analysis}
\usage{
ren(
  dat,
  date_column_index = 1,
  start_date = "19990101",
  end_date = "20231231",
  num_cores = 2
)
}
\arguments{
\item{dat}{A data frame or matrix where the first column is the date and the remaining columns are the data.}

\item{date_column_index}{The index of the date column in the input data. Default is 1.}

\item{start_date}{A character string specifying the start date for filtering the data in 'YYYYMMDD' format.
Default is '19990101'.}

\item{end_date}{A character string specifying the end date for filtering the data in 'YYYYMMDD' format.
Default is '20231231'.}

\item{num_cores}{The number of cores to use for parallel processing. Default is 2.}
}
\value{
The results from `perform_analysis`, including plots and performance metrics.
}
\description{
This function integrates data preparation, parallel setup, and portfolio analysis.
It takes raw data as input, prepares it using `prepare_data`, sets up parallel processing
using `setup_parallel`, and performs the analysis using `perform_analysis`.
}
\examples{
\dontrun{
# load the sample data
dat(FF25)
# Run the main function
result <- ren(FF25)

# Display results
print(result$cumulative_return_plot)
print(result$cumulative_turnover_plot)
}

}
