% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.pasin.R
\name{model.pasin}
\alias{model.pasin}
\title{Model from Pasin and al.,2019}
\usage{
model.pasin(t, y, parms)
}
\arguments{
\item{t}{vector of time ;}

\item{y}{initial condition, named vector of form \code{c(Ab=<...>,S=<...>,L=<...>)} ;}

\item{parms}{named vector of model parameter ; should contain "\code{theta_S}","\code{theta_L}","\code{delta_Ab}","\code{delta_S}","\code{delta_L}".}
}
\value{
Matrix of \code{time} and observation of antibody titer \code{Ab}, and ASCs \code{S} and \code{L}.
}
\description{
Generate trajectory of the Humoral Immune Response to a Prime-Boost Ebola Vaccine.
}
\details{
The model correspond to the dynamics of the humoral response, from 7 days after the boost immunization with antibodies secreting cells -\eqn{S} and \eqn{L}, characterized by their half lives- that produces antibodies -\eqn{AB}- at rate \eqn{\theta_S} and \eqn{\theta_L}. All these biological entities decay at rate repectively \eqn{\delta_S, \delta_L} and \eqn{\delta_{Ab}}. Model is then defined as
\deqn{ \left\{\begin{matrix}\frac{d}{dt} Ab(t) &=& \theta_S S(t) + \theta_L L(t) - \delta_{Ab} Ab(t)  \\ \frac{d}{dt}S(t) &=& -\delta_S S(t) \\ \frac{d}{dt} L(t) &=& -\delta_L L(t)\end{matrix}\right. }
}
\examples{
y = c(Ab=0,S=5,L=5)
parms = c(theta_S = 611,
          theta_L = 3.5,
          delta_Ab = 0.025,
          delta_S = 0.231,
          delta_L = 0.000152)

t = seq(0,100,5)
res <- model.pasin(t,y,parms)
plot(res)

}
\references{
Pasin C, Balelli I, Van Effelterre T, Bockstal V, Solforosi L, Prague M, Douoguih M, Thiébaut R, for the EBOVAC1 Consortium. 2019. Dynamics of the humoral immune response to a prime-boost Ebola vaccine: quantification and sources of variation. J Virol 93: e00579-19. https://doi.org/10.1128/JVI.00579-19
}
\seealso{
\code{\link{indParm}}, \code{\link{model.clairon}}.
}
