% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-report.R
\name{redcap_report}
\alias{redcap_report}
\title{Read/Export records that populate a REDCap report}
\usage{
redcap_report(
  redcap_uri,
  token,
  report_id,
  raw_or_label = "raw",
  raw_or_label_headers = "raw",
  export_checkbox_label = FALSE,
  col_types = NULL,
  guess_type = TRUE,
  guess_max = 1000,
  verbose = TRUE,
  config_options = NULL,
  handle_httr = NULL
)
}
\arguments{
\item{redcap_uri}{The
\href{https://en.wikipedia.org/wiki/Uniform_Resource_Identifier}{uri}/url
of the REDCap server
typically formatted as "https://server.org/apps/redcap/api/".
Required.}

\item{token}{The user-specific string that serves as the password for a
project.  Required.}

\item{report_id}{A single integer, provided next to the report name on the
report list page.  Required.}

\item{raw_or_label}{A string (either \code{'raw'} or \code{'label'}) that specifies
whether to export the raw coded values or the labels for the options of
multiple choice fields.  Default is \code{'raw'}.}

\item{raw_or_label_headers}{A string (either \code{'raw'} or \code{'label'} that
specifies for the CSV headers whether to export the variable/field names
(raw) or the field labels (label).  Default is \code{'raw'}.}

\item{export_checkbox_label}{specifies the format of checkbox field values
specifically when exporting the data as labels.  If \code{raw_or_label} is
\code{'label'} and \code{export_checkbox_label} is TRUE, the values will be the text
displayed to the users.  Otherwise, the values will be 0/1.}

\item{col_types}{A \code{\link[readr:cols]{readr::cols()}} object passed internally to
\code{\link[readr:read_delim]{readr::read_csv()}}.  Optional.}

\item{guess_type}{A boolean value indicating if all columns should be
returned as character.  If true, \code{\link[readr:read_delim]{readr::read_csv()}} guesses the intended
data type for each column.  Ignored if \code{col_types} is not null.}

\item{guess_max}{A positive \link[base:numeric]{base::numeric} value
passed to \code{\link[readr:read_delim]{readr::read_csv()}} that
specifies the maximum number of records to use for guessing column types.}

\item{verbose}{A boolean value indicating if \code{message}s should be printed
to the R console during the operation.  The verbose output might contain
sensitive information (\emph{e.g.} PHI), so turn this off if the output might
be visible somewhere public. Optional.}

\item{config_options}{A list of options passed to \code{\link[httr:POST]{httr::POST()}}.
See details at \code{\link[httr:httr_options]{httr::httr_options()}}. Optional.}

\item{handle_httr}{The value passed to the \code{handle} parameter of
\code{\link[httr:POST]{httr::POST()}}.
This is useful for only unconventional authentication approaches.  It
should be \code{NULL} for most institutions.  Optional.}
}
\value{
Currently, a list is returned with the following elements:
\itemize{
\item \code{data}: A \code{\link[tibble:tibble]{tibble::tibble()}} of the desired records and columns.
\item \code{success}: A boolean value indicating if the operation was apparently
successful.
\item \code{status_code}: The
\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{http status code}
of the operation.
\item \code{outcome_message}: A human readable string indicating the operation's
outcome.
\item \code{elapsed_seconds}: The duration of the function.
\item \code{raw_text}: If an operation is NOT successful, the text returned by
REDCap.  If an operation is successful, the \code{raw_text} is returned as an
empty string to save RAM.
}
}
\description{
Exports the data set of a report created on a project's
'Data Exports, Reports, and Stats' page.
}
\examples{
\dontrun{
uri          <- "https://redcap-dev-2.ouhsc.edu/redcap/api/"
token        <- "9A068C425B1341D69E83064A2D273A70"

report_1_id  <- 12L
report_2_id  <- 13L

# Return all records and all variables.
ds_1a <-
  REDCapR::redcap_report(
    redcap_uri = uri,
    token      = token,
    report_id  = report_1_id
  )$data


# Specify the column types.
col_types_1 <- readr::cols(
  record_id          = readr::col_integer(),
  height             = readr::col_double(),
  health_complete    = readr::col_integer(),
  address            = readr::col_character(),
  ethnicity          = readr::col_integer()
)
ds_1b <-
  REDCapR::redcap_report(
    redcap_uri = uri,
    token      = token,
    report_id  = report_1_id,
    col_types  = col_types_1
  )$data


# Return condensed checkboxes Report option:
#   "Combine checkbox options into single column of only the checked-off
#   options (will be formatted as a text field when exported to
#   stats packages)"
col_types_2 <- readr::cols(
  record_id          = readr::col_integer(),
  race               = readr::col_character()
)
ds_2 <-
  REDCapR::redcap_report(
    redcap_uri = uri,
    token      = token,
    report_id  = report_2_id,
    col_types  = col_types_2
  )$data
}
}
\references{
The official documentation can be found on the 'API Help Page'
and 'API Examples' pages on the REDCap wiki (\emph{i.e.},
https://community.projectredcap.org/articles/456/api-documentation.html and
https://community.projectredcap.org/articles/462/api-examples.html).
If you do not have an account for the wiki, please ask your campus REDCap
administrator to send you the static material.
}
\author{
Will Beasley
}
