% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_redcap_project.R
\name{export_core}
\alias{export_core}
\title{Export Core}
\usage{
export_core(uri = NULL, token = NULL, format = NULL, verbose = TRUE, ...)
}
\arguments{
\item{uri}{The URI for the REDCap API.  If \code{NULL} (default) the value
\code{Sys.getenv("REDCap_API_URI")} is used.}

\item{token}{The API token for the project you want to export from. If
\code{NULL} (default) the value \code{Sys.getenv("REDCap_API_TOKEN")} is
used.}

\item{format}{The format to return. If \code{NULL} (default) the value
\code{Sys.getenv("REDCap_API_format")} is used.}

\item{verbose}{provide messages to tell the user what is happening}

\item{...}{not currently used}
}
\value{
A \code{rcer_rccore} object: a list with the project info, metadata,
user table, and records, all in a "raw" format direct from the API.
}
\description{
Export Core Contents of a REDCap Project.
}
\examples{

# A reproducible example would require a REDCap project, accessible via an
# API token.  An example of the return from these calls are provided as data
# with this package.

# avs_raw_core <- export_core()

data(avs_raw_core)
str(avs_raw_core)

}
