% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLmix.R
\name{HLmix}
\alias{HLmix}
\title{Kiefer-Wolfowitz NPMLE for Huber Location Mixtures}
\usage{
HLmix(x, v = 300, sigma = 1, k = 1.345, heps = hubereps(k), ...)
}
\arguments{
\item{x}{Data: Sample Observations}

\item{v}{Undata: Grid Values defaults equal spacing of with v bins, when v is
a scalar}

\item{sigma}{scale parameter of the Gaussian noise, may take vector values
of length(x)}

\item{k}{Huber k value}

\item{heps}{Huber epsilon contamination value, should match k, by default
this is automatically enforced.}

\item{...}{other parameters to pass to KWDual to control optimization}
}
\value{
An object of class density with components: 
     \item{x}{points of  evaluation on the domain of the density} 
     \item{y}{estimated function values at the points v, the mixing density} 
     \item{g}{marginal density values}
     \item{logLik}{log likelihood}
     \item{sigma}{sigma}
     \item{dy}{posterior means at the observed \code{x} values}
     \item{k}{Huber k}
     \item{heps}{Huber epsilon}
}
\description{
Kiefer Wolfowitz Nonparametric MLE for Huber Location Mixtures
}
\details{
Kiefer Wolfowitz NPMLE for location mixtures with Huber (1964) base density
The Huber \code{k} specifies the point at which the influence function of
the Huber M-estimator kinks.  
The predict method for \code{HLmix} objects compute means, medians or
modes of the posterior according to whether the \code{Loss} argument is 2, 1
or 0, or posterior quantiles if \code{Loss} is in (0,1).
}
\author{
Roger Koenker
}
