% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{GetDistance}
\alias{GetDistance}
\title{Euclidean distance between predicted and actual recruitment}
\usage{
GetDistance(
  target,
  nSim = 10000L,
  fillGaps = FALSE,
  cauchyWt = FALSE,
  efficiencyFactor = 1
)
}
\arguments{
\item{target}{A vector with the actual recruitment by week}

\item{nSim}{Number of simulations to run (default = 1e4L). Accepted values are in the \if{html}{\out{<br>}}
range of 1 to 10,000.}

\item{fillGaps}{Whether to fill recruitment gaps in the data (default = FALSE).\if{html}{\out{<br>}}
Recruitment gaps are defined as any full week (Monday through Sunday) with\if{html}{\out{<br>}}
no dates recorded in the loaded data. If at least one date is present within\if{html}{\out{<br>}}
a given week, that week will not be considered a gap in recruitment.}

\item{cauchyWt}{Whether to use Cauchy weights for sampling.
If FALSE (default),\if{html}{\out{<br>}}
binomial weights are used.}

\item{efficiencyFactor}{An efficiency coefficient to apply to the recruitment rate (default = 1).\if{html}{\out{<br>}}
If the efficiency of the recruitment process is expected to match\if{html}{\out{<br>}}
the provided data, this value should be set to 1. If the recruitment\if{html}{\out{<br>}}
process is expected to be slower, this value should less than 1. Finally,\if{html}{\out{<br>}}
if the recruitment process is expected to proceed faster, this value should be\if{html}{\out{<br>}}
greater than 1. Accepted values range from 0.1 to 2:\if{html}{\out{<br>}}
\itemize{
\item 0.1: Indicates that the recruitment rate is expected to be 10\% of the original rate.
\item 2.0: Indicates that the recruitment rate is expected to be double the original rate.
}}
}
\value{
An object of \code{RCTDist} class with four elements.
\enumerate{
\item \code{dist}:
A numeric vector with length equal to \code{nSim} containing the simulated\if{html}{\out{<br>}}
Euclidean distance.
\item \code{CI}: A numeric vector with the median and the 95\% CI Euclidean distance.
\item \code{call.}: The call (deparsed) that created the object
\item \code{cargs}: A list with the arguments of the call that created the object\if{html}{\out{<br>}}
including the default arguments
}
}
\description{
Euclidean distance between predicted and actual recruitment
}
\examples{
LoadData(gripsYR1, ScreenDt, Enrolled)
(res <- GetDistance(gripsYR2Weekly$enrolled))
str(res)
}
\seealso{
Other Links: 
\code{\link{GetWeekPredCI}()},
\code{\link{LoadData}()},
\code{\link{RCTRecruit-package}},
\code{\link{Time2Nsubjects}()},
\code{\link{gripsYR1}},
\code{\link{gripsYR2}},
\code{\link{gripsYR2Weekly}},
\code{\link{plot.RCTPredCI}()}
}
\concept{Links}
