% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCGLS-functions.R
\name{download_CGLS_data}
\alias{download_CGLS_data}
\title{Download CGLS data}
\usage{
download_CGLS_data(username, password, timeframe, product, resolution, version)
}
\arguments{
\item{username}{Register at https://land.copernicus.eu/global/}

\item{password}{Register at https://land.copernicus.eu/global/}

\item{timeframe}{Time frame of interest, for example June 2019}

\item{product}{Product name: fapar, fcover, lai, ndvi,  ss, swi, lst, ...}

\item{resolution}{1km, 300m or 100m}

\item{version}{Version number: v1, v2, v3,...}
}
\value{
CGLS data Data saved locally in chosen folder.
}
\description{
Downloads manifest files of the Copernicus Global Land Service. Registration at https://land.copernicus.eu/global/ is required.
}
\details{
Check https://land.copernicus.eu/global/products/ for a product overview and product details. Check https://land.copernicus.vgt.vito.be/manifest/ for an overview for data availability in the manifest.
}
\examples{
\dontrun{
#library(RCurl)
UN   <- "Willemijn" 
PW   <- "Testthis"
TF   <- seq(as.Date("2019-06-01"), as.Date("2019-06-15"), by="days")
PROD <- "fapar" #Product name: fapar, fcover, lai, ndvi,  ss, swi, lst, ...
RES  <- "1km" #1km, 300m or 100m
V    <- "v1" #Version number: v1, v2, v3, ...

download_CGLS_data(username=UN, password=PW, timeframe=TF, product=PROD, resolution=RES, version=V) 
}
}
