% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcbr.fit.GK.R
\name{rcbr.fit.GK}
\alias{rcbr.fit.GK}
\title{Gautier and Kitamura (2013) bivariate random coefficient binary response}
\usage{
rcbr.fit.GK(X, y, control)
}
\arguments{
\item{X}{the design matrix expected to have an intercept column of
ones as the first column.}

\item{y}{the binary response.}

\item{control}{is a list of tuning parameters for the fitting,see
\code{GK.control} for further details.}
}
\value{
a list with components:
\describe{
  \item{u}{grid values}
  \item{v}{grid values}
  \item{w}{estimated function values on 2d u x v grid}
  \item{X}{design matrix}
  \item{y}{response vector} 
}
}
\description{
This is an implementation based on the matlab version of Gautier and
Kitamura's deconvolution method for the bivariate random coefficient 
binary response model.  Methods based on the fitted object are provided
for \code{predict}, \code{logLik} and \code{plot}.requires orthopolynom
package for Gegenbauer polynomials
}
\references{
Gautier, E. and Y. Kitamura (2013)  Nonparametric estimation in random coefficients
binary choice models, \emph{Ecoonmetrica}, 81, 581-607.
}
\author{
Gautier and Kitamura for original matlab version, Jiaying Gu
and Roger Koenker for the R translation.
}
\keyword{nonparametrics}
