% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sa.time.R
\name{sa.time}
\alias{sa.time}
\title{Sensitivity of R0 to time estimation windows}
\usage{
sa.time(
  incid,
  GT,
  begin = NULL,
  end = NULL,
  est.method,
  t = NULL,
  date.first.obs = NULL,
  time.step = 1,
  res = NULL,
  ...
)
}
\arguments{
\item{incid}{A vector of incident cases.}

\item{GT}{Generation time distribution from \code{\link[=generation.time]{generation.time()}}.}

\item{begin}{Vector of begin dates for the estimation of epidemic.}

\item{end}{Vector of end dates for estimation of the epidemic.}

\item{est.method}{Estimation method used for sensitivity analysis.}

\item{t}{Dates vector to be passed to estimation function.}

\item{date.first.obs}{Optional date of first observation, if t not specified.}

\item{time.step}{Optional. If date of first observation is specified, number of day between each incidence observation.}

\item{res}{If specified, will extract most of data from a \code{R0.R}-class contained within the \verb{$estimate} component of a result from \code{\link[=estimate.R]{estimate.R()}} and run sensitivity analysis with it.}

\item{...}{Parameters passed to inner functions}
}
\value{
A list with components :
\item{df}{data.frame object with all results from sensitivity analysis.}
\item{df.clean}{the same object, with NA rows removed. Used only for easy export of results.}
\item{mat.sen}{Matrix with values of R0 given begin (rows) and end (columns) dates.}
\item{begin}{A range of begin dates in epidemic.}
\item{end}{A range of end dates in epidemic.}
}
\description{
Sensitivity analysis to estimate the variation of reproduction numbers
according to period over which the incidence is analyzed.
}
\details{
By varying different pairs of begin and end dates,different estimates of
reproduction ratio can be analyzed.

'begin' and 'end' vector must have the same length for the sensitivity
analysis to run. They can be provided either as dates or numeric values,
depending on the other parameters (see \code{\link[=check.incid]{check.incid()}}). If some begin/end
dates overlap, they are ignored, and corresponding uncomputed data are set
to \code{NA}.

Also, note that unreliable Rsquared values are achieved for very small time
periods (begin ~ end). These values are not representative of the epidemic
outbreak behaviour.
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
