# Tests for plotting functions

test_that("plot_qq_3d returns plotly object", {
  skip_if_not_installed("plotly")
  
  set.seed(42)
  x <- rnorm(50)
  y <- rnorm(50)
  
  result <- qq_regression(y, x, 
                          y_quantiles = c(0.25, 0.5, 0.75),
                          x_quantiles = c(0.25, 0.5, 0.75),
                          verbose = FALSE)
  
  p <- plot_qq_3d(result, type = "coefficient")
  
  expect_s3_class(p, "plotly")
})

test_that("plot_qq_3d works with all types", {
  skip_if_not_installed("plotly")
  
  set.seed(42)
  x <- rnorm(50)
  y <- rnorm(50)
  
  result <- qq_regression(y, x, 
                          y_quantiles = c(0.25, 0.5, 0.75),
                          x_quantiles = c(0.25, 0.5, 0.75),
                          verbose = FALSE)
  
  expect_s3_class(plot_qq_3d(result, type = "coefficient"), "plotly")
  expect_s3_class(plot_qq_3d(result, type = "rsquared"), "plotly")
  expect_s3_class(plot_qq_3d(result, type = "pvalue"), "plotly")
})

test_that("plot_qq_3d works with all colorscales", {
  skip_if_not_installed("plotly")
  
  set.seed(42)
  x <- rnorm(50)
  y <- rnorm(50)
  
  result <- qq_regression(y, x, 
                          y_quantiles = c(0.25, 0.5, 0.75),
                          x_quantiles = c(0.25, 0.5, 0.75),
                          verbose = FALSE)
  
  expect_s3_class(plot_qq_3d(result, colorscale = "Jet"), "plotly")
  expect_s3_class(plot_qq_3d(result, colorscale = "BlueRed"), "plotly")
  expect_s3_class(plot_qq_3d(result, colorscale = "Viridis"), "plotly")
  expect_s3_class(plot_qq_3d(result, colorscale = "Plasma"), "plotly")
})

test_that("plot_qq_heatmap returns plotly object", {
  skip_if_not_installed("plotly")
  
  set.seed(42)
  x <- rnorm(50)
  y <- rnorm(50)
  
  result <- qq_regression(y, x, 
                          y_quantiles = c(0.25, 0.5, 0.75),
                          x_quantiles = c(0.25, 0.5, 0.75),
                          verbose = FALSE)
  
  p <- plot_qq_heatmap(result, type = "coefficient")
  
  expect_s3_class(p, "plotly")
})

test_that("plot_qq_contour returns plotly object", {
  skip_if_not_installed("plotly")
  
  set.seed(42)
  x <- rnorm(50)
  y <- rnorm(50)
  
  result <- qq_regression(y, x, 
                          y_quantiles = c(0.25, 0.5, 0.75),
                          x_quantiles = c(0.25, 0.5, 0.75),
                          verbose = FALSE)
  
  p <- plot_qq_contour(result)
  
  expect_s3_class(p, "plotly")
})

test_that("plot_qq_correlation returns plotly object", {
  skip_if_not_installed("plotly")
  
  set.seed(42)
  x <- rnorm(50)
  y <- rnorm(50)
  
  p <- plot_qq_correlation(y, x, quantiles = c(0.25, 0.5, 0.75))
  
  expect_s3_class(p, "plotly")
})

test_that("plot_qq_correlation validates inputs", {
  expect_error(plot_qq_correlation("a", c(1, 2, 3)))
  expect_error(plot_qq_correlation(c(1, 2, 3), "b"))
  expect_error(plot_qq_correlation(c(1, 2, 3), c(1, 2)))
})

test_that("qq_colorscales returns character vector", {
  scales <- qq_colorscales(show_preview = FALSE)
  
  expect_type(scales, "character")
  expect_true("Jet" %in% scales)
  expect_true("Viridis" %in% scales)
})
