% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{qq_to_matrix}
\alias{qq_to_matrix}
\title{Convert QQ Results to Matrix}
\usage{
qq_to_matrix(qq_result, type = c("coefficient", "rsquared", "pvalue"))
}
\arguments{
\item{qq_result}{An object of class "qq_regression" or a data frame.}

\item{type}{Character string. Type of values: "coefficient", "rsquared",
or "pvalue". Default is "coefficient".}
}
\value{
A matrix with y_quantiles as rows and x_quantiles as columns.
}
\description{
Converts QQ regression results to a matrix format suitable for base R
plotting or export.
}
\examples{
# Generate example data
set.seed(42)
n <- 200
x <- rnorm(n)
y <- 0.5 * x + rnorm(n, sd = 0.5)

# Run QQ regression
result <- qq_regression(y, x, verbose = FALSE)

# Convert to matrix
coef_matrix <- qq_to_matrix(result, type = "coefficient")
print(dim(coef_matrix))

}
