% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_qq_contour}
\alias{plot_qq_contour}
\title{Contour Plot for QQ Regression}
\usage{
plot_qq_contour(
  qq_result,
  type = c("coefficient", "rsquared", "pvalue"),
  colorscale = "Jet",
  show_labels = TRUE,
  x_label = "X Variable Quantiles",
  y_label = "Y Variable Quantiles",
  title = NULL
)
}
\arguments{
\item{qq_result}{An object of class "qq_regression" or a data frame
with columns: y_quantile, x_quantile, coefficient.}

\item{type}{Character string. Type of values to plot: "coefficient"
(default), "rsquared", or "pvalue".}

\item{colorscale}{Character string. Color scale to use. Default is "Jet".}

\item{show_labels}{Logical. If \code{TRUE}, shows contour labels.
Default is \code{TRUE}.}

\item{x_label}{Character string. Label for x-axis. Default is
"X Variable Quantiles".}

\item{y_label}{Character string. Label for y-axis. Default is
"Y Variable Quantiles".}

\item{title}{Character string. Plot title. If \code{NULL}, an
automatic title is generated.}
}
\value{
A plotly object representing the contour plot.
}
\description{
Creates an interactive contour plot of QQ regression coefficients using
plotly.
}
\examples{
# Generate example data
set.seed(42)
n <- 200
x <- rnorm(n)
y <- 0.5 * x + rnorm(n, sd = 0.5)

# Run QQ regression
result <- qq_regression(y, x, verbose = FALSE)

\donttest{
# Create contour plot
plot_qq_contour(result)
}

}
