% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPerformance.R
\name{plotPerformance}
\alias{plotPerformance}
\title{Plot measure performance across accountable entities}
\usage{
plotPerformance(df, plot.type = "p")
}
\arguments{
\item{df}{perf.results dataframe from \code{calcPerformance()} output}

\item{plot.type}{specifies which plot to return:
\itemize{
\item \code{p}: plots the entity-level unadjusted outcome rates
\item \code{oe}: plots the entity-level observed-to-expected risk-standardized rates
\item \code{pe}: plots the predicted-to-expected risk-standardized rates
\item \code{OR}: plots the odds ratios comparing each entity with the average entity; i.e., exponentiated random intercepts from the hierarchical logistic regression model.
\item \code{correlation}: plot of standardization ratios against the entity random intercepts
\item \code{multiple}: plot of measure performance across different risk-adjustment methods
}}
}
\value{
A ggplot figure
}
\description{
This function creates a plot of measure performance across accountable entities, using the \code{perf.results} dataframe from \code{calcPerformance()} output.
}
\examples{
# simulate data
df <- simulateData(n.entity = 50, n.obs = 100, mu = .2, r = .7)

# calculate measure performance
out <- calcPerformance(df = df, entity = 'entity', y = 'y')

# plot performance
plotPerformance(out$perf.results, plot.type = 'p')

}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
