% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QI_F.R
\name{QIPoly}
\alias{QIPoly}
\title{Quantity-intensity (Q/I) relationship of soil K derived through a second order polynomial i.e., quadratic equation}
\usage{
QIPoly(Solution2Soil = Solution2Soil, CKi = CKi, CKf = CKf, CCaMg = CCaMg)
}
\arguments{
\item{Solution2Soil}{Ratio of solution volume to soil mass (mL/g or L/kg)}

\item{CKi}{Initial K concentration (mg/L)}

\item{CKf}{Final or equilibrium K concentration (mg/L)}

\item{CCaMg}{Final or equilibrium 'Ca+Mg' concentration (mol/L)}
}
\value{
AReK - Equilibrium activity ratio (unitless)
Kl - Total labile K (cmolc/kg)
PBCK - Potential buffering capacity (cmolc/kg)
deltaG0 - The standard free energy of exchange (cal/mol)
}
\description{
A quadratic equation of the form "y = ax2 + bx + c" can be fitted to Q/I data to find out different Q/I parameters
}
\examples{
with(data = df, QIPoly(Solution2Soil = Solution_to_Soil_Ratio, CKi = Initial_K,
CKf = Final_K, CCaMg = Final_Ca_and_Mg))
}
\references{
Wang, J.J., Harrell, D.L., Bell, P.F., 2004. Potassium buffering characteristics of three soils low in exchangeable potassium. Soil Science Society of America Journal 68, 654-661.

Wang, J.J., Scott, A.D., 2001. Effect of experimental relevance on potassium Q/I relationships and its implications for surface and subsurface soils. Communications in Soil Science and Plant Analysis 32, 2561-2575.
}
