% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Barrier.R
\name{BarrierBS}
\alias{BarrierBS}
\title{Barrier option pricing via Black-Scholes (BS) model}
\usage{
BarrierBS(o = OptPx(Opt(Style = "Barrier")), dir = c("Up", "Down"),
  knock = c("In", "Out"), H = 40)
}
\arguments{
\item{o}{The \code{OptPx} option object to price. See \code{OptBarrier()}, \code{OptPx()}, and \code{Opt()} for more information.}

\item{dir}{The direction of the option to price. Either Up or Down.}

\item{knock}{Whether the option goes In or Out when the barrier is reached.}

\item{H}{The barrier level}
}
\value{
The price of the barrier option \code{o}, which is based on the BSM-adjusted algorithm (see references).
}
\description{
This function calculates the price of a Barrier option. This price is based on the assumptions that
the probability distribution is lognormal and that the asset price is observed continuously.
}
\details{
To price the barrier option, we need to know whether the option is Up or Down | In or Out | Call or Put. Beyond that
 we also need the S0, K, r, q, vol, H, and ttm arguments from the object classes defined in the package.
}
\examples{
(o = BarrierBS())$PxBS # Option with default arguments is valued at $9.71

 #Down-and-In-Call
 o = Opt(Style='Barrier', S0=50, K=50, ttm=1, Right="Call", ContrSize=10)
 o = OptPx(o,  r = .05, q = 0, vol = .25)
 o = BarrierBS(o, dir = "Down", knock = 'In', H = 40)

 #Down-and-Out Call
 o = Opt(Style='Barrier', S0=50, K=50, ttm=1, Right="Call", ContrSize=10)
 o = OptPx(o, r = .05, q = .02, vol = .25)
 o = BarrierBS(o, dir = "Down", knock = 'Out', H = 40)

 #Up-and-In Call
 o = Opt(Style='Barrier', S0=50, K=50, ttm=1, Right="Call", ContrSize=1)
 o = OptPx(o, r = .05, q = .02, vol = .25)
 o = BarrierBS(o, dir = "Up", knock = 'In', H = 60)

 #Up-and-Out Call
 o = Opt(Style='Barrier', S0 = 50, K = 50, ttm = 1, Right="Call", ContrSize=1)
 o = OptPx(o, r = .05, q = .02, vol = .25)
 o = BarrierBS(o, dir = "Up", knock = 'Out', H = 60)

 #Down-and-In Put
 o = Opt(Style='Barrier', S0=50, K=50, ttm=1, Right="Put", ContrSize=1)
 o = OptPx(o, r = .05, q = .02, vol = .25)
 o = BarrierBS(o, dir = "Down", knock = 'In', H = 40)

 #Down-and-Out Put
 o = Opt(Style='Barrier', S0=50, K=50, ttm=1, Right="Put", ContrSize=1)
 o = OptPx(o, r = .05, q = .02, vol = .25)
 o = BarrierBS(o, dir = "Down", knock = 'Out', H = 40)

 #Up-and-In Put
 o = Opt(Style='Barrier', S0=50, K=50, ttm=1, Right="Put", ContrSize=1)
 o = OptPx(o, r = .05, q = .02, vol = .25)
 o = BarrierBS(o, dir = "Up", knock = 'In', H = 60)

 #Up-and-Out Put
 o = Opt(Style='Barrier', S0=50, K=50, ttm=1, Right="Put", ContrSize=1)
 o = OptPx(o, r = .05, q = .02, vol = .25)
 o = BarrierBS(o, dir = "Up", knock = 'Out', H = 60)
}
\author{
Kiryl Novikau, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8. \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
 pp.606-607
}

