% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Shout.R
\name{ShoutMC}
\alias{ShoutMC}
\title{Shout option valuation via Monte Carlo (MC) simulations.}
\usage{
ShoutMC(o = OptPx(o = Opt(Style = "Shout")), NPaths = 10)
}
\arguments{
\item{o}{The \code{OptPx} Shout option to price.}

\item{NPaths}{The number of simulation paths to use in calculating the price; must be >= 10}
}
\value{
The option object \code{o} with the price in the field \code{PxMC} based on the MC simulations.
}
\description{
Calculates the price of a shout option using Monte Carlo simulations to
determine expected payout. Assumes that the option follows a General
Brownian Motion  (GBM) process, \eqn{ds = mu * S * dt + sqrt(vol) * S * dW} where \eqn{dW ~ N(0,1)}.
Note that the value of \eqn{mu} (the expected price increase) is assumped to be
\code{o$r}, the risk free rate of return.
}
\examples{
(o = ShoutMC())$PxMC # Approximately valued at $11

  o = Opt(Style='Shout')
  (o = ShoutMC(OptPx(o, NSteps = 5)))$PxMC # Approximately valued at $18.6

  o = Opt(Style='Shout',S0=110,K=100,ttm=.5)
  o = OptPx(o, r=.05, vol=.2, q=0, NSteps = 10)
  (o = ShoutMC(o, NPaths = 10))$PxMC
}
\author{
Jake Kornblau, Department of Statistics, Rice University, 2015
}
\references{
Hull, J.C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
 ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
 \cr
 Also: \url{http://www.math.umn.edu/~spirn/5076/Lecture16.pdf}
}

