% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ForeignEquity.R
\name{ForeignEquityBS}
\alias{ForeignEquityBS}
\title{ForeignEquity option valuation via Black-Scholes (BS) model}
\usage{
ForeignEquityBS(o = OptPx(Opt(Style = "ForeignEquity")), I1 = 1540,
  I2 = 1/90, sigma1 = 0.14, sigma2 = 0.18, g1 = 0.02, rho = -0.3,
  Type = c("Foreign", "Domestic"))
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{I1}{A spot price of the underlying security 1 (usually I1)}

\item{I2}{A spot price of the underlying security 2 (usually I2)}

\item{sigma1}{a vector of implied volatilities for the associated security 1}

\item{sigma2}{a vector of implied volatilities for the associated security 2}

\item{g1}{is the payout rate of the first stock}

\item{rho}{is the correlation between asset 1 and asset 2}

\item{Type}{ForeignEquity option type: 'Foreign' or 'Domestic'}
}
\value{
A list of class \code{ForeignEquityBS} consisting of the original \code{OptPx} object
and the option pricing parameters \code{I1},\code{I2}, \code{Type}, \code{isForeign}, and \code{isDomestic}
as well as the computed price \code{PxBS}.
}
\description{
ForeignEquity Option via Black-Scholes (BS) model
}
\details{
Two types of ForeignEquity options are priced: \code{'Foreign'} and \code{'Domestic'}.
See "Exotic Options", 2nd, Peter G. Zhang for more details.
}
\examples{
o = OptPx(Opt(Style = 'ForeignEquity', Right = "Put"), r= 0.03)
ForeignEquityBS(o, I1=1540, I2=1/90, g1=.02, sigma1=.14,sigma2=0.18, rho=.03,Type='Foreign')

o = OptPx(Opt(Style = 'ForeignEquity',  Right = "Put", ttm=9/12, K=1600), r=.03)
ForeignEquityBS(o, I1=1540, I2=1/90, g1=.02, sigma1=.14,sigma2=0.18, rho=0.03,Type='Foreign')

o = OptPx(Opt(Style = 'ForeignEquity', Right = "C", ttm=9/12, K=1600), r=.03)
ForeignEquityBS(o, I1=1540, I2=1/90, g1=.02, sigma1=.14,sigma2=0.18, rho=0.03,Type='Foreign')

o = OptPx(Opt(Style = 'ForeignEquity', Right = "C", ttm=9/12, K=1600), r=.03)
ForeignEquityBS(o, I1=1540, I2=1/90, g1=.02, sigma1=.14,sigma2=0.18, rho=0.03,Type='Domestic')

o = OptPx(Opt(Style = 'ForeignEquity', Right = "P", ttm=9/12, K=1600), r=.03)
ForeignEquityBS(o, I1=1540, I2=1/90, g1=.02, sigma1=.14,sigma2=0.18, rho=0.03,Type='Domestic')
}
\author{
Chengwei Ge, Department of Statistics, Rice University, 2015
}
\references{
Zhang, Peter G.  \emph{Exotic Options}, 2nd, 1998.
}

