% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Chooser.R
\name{ChooserMC}
\alias{ChooserMC}
\title{Chooser option valuation via Monte Carlo (MC) simulations}
\usage{
ChooserMC(o = OptPx(Opt(Style = "Chooser")), isEu = TRUE, T1 = 1,
  NPaths = 5, plot = FALSE)
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{isEu}{Values \code{TRUE} or \code{FALSE} indicating
if the chooser is an European or American style option}

\item{T1}{The time when the choice is made whether the option is a call or put}

\item{NPaths}{The number of Monte Carol simulation paths}

\item{plot}{Values \code{TRUE} or \code{FALSE} indicating
whether to include a comparison plot of option price versus number of paths}
}
\value{
A list of class \code{ChooserMC} consisting of original \code{OptPx} object,
option pricing parameters \code{isEu}, \code{NPaths}, and \code{T1},
as well as the computed price \code{PxMC} for the chooser option.
}
\description{
Price chooser option using Monte Carlo (MC) simulation.
}
\details{
A chooser option (sometimes referred to as an as you like it option) has the feature that,
after a specified period of time, the holder can choose whether the option is a call or a put.
In this algorithm, we can price chooser options when the underlying options are both European or are both American.
When the underlying is an American option, the option holder can exercise before and after T1.
}
\examples{
(o = ChooserMC())$PxMC

o = OptPx(Opt(Right='Call',Style="Chooser"))
 ChooserMC(o,isEu=TRUE,NPaths=5, plot=TRUE)

 o = OptPx(Opt(Right='Put',Style="Chooser"))
 ChooserMC(o,isEu=TRUE,NPaths=5, plot=TRUE)

 o = Opt(Right='C',S0=100,K=110,ttm=4,Style="Chooser")
 o = OptPx(o,vol=0.2,r=0.05,q=0.04)
 ChooserMC(o,isEu=TRUE,T1=2,NPaths=5)

 o = Opt(Right='P',S0=110,K=100,ttm=4,Style="Chooser")
 o = OptPx(o,vol=0.2,r=0.05,q=0.04)
 ChooserMC(o,isEu=TRUE,T1=2,NPaths=5)

 o = Opt(Right='C',S0=50,K=50,ttm=0.5,Style="Ch")
 o = OptPx(o,vol=0.25,r=0.08,q=0.1)
 ChooserMC(o,isEu=FALSE,T1=0.25,NPaths=5)
}
\author{
Xinnan Lu, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
p.603.
}

