% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gigwa.R
\name{gigwa_get_variants}
\alias{gigwa_get_variants}
\title{Get Available Variants in the Selected GIGWA Run}
\usage{
gigwa_get_variants(
  max_missing = 1,
  min_maf = 0.5,
  samples = NULL,
  start = NULL,
  end = NULL,
  referenceName = NULL
)
}
\arguments{
\item{max_missing}{The maximum allowable missing data ratio, between 0 and 1 (default is 1, meaning up to 100\% missing data).}

\item{min_maf}{Minimum Minor Allele Frequency (MAF) between 0 and 0.5 (default is 0).}

\item{samples}{A list of sample names to include in the query (optional). If NULL, all samples will be included.}

\item{start}{Start position of the query region (zero-based, inclusive).}

\item{end}{End position of the query region (zero-based, exclusive).}

\item{referenceName}{The reference sequence name (e.g., chromosome).}
}
\value{
A data frame where the first 4 columns describe the SNP (rs# variant name, alleles, chrom, pos), 
and subsequent columns contain numerical genotyping information (0 for reference allele, 1 for heterozygous, and 2 for minor allele).
}
\description{
Retrieve variant data (e.g., SNP markers) for the selected GIGWA run based on filtering criteria, 
including minor allele frequency, missing data threshold, and sample subset.
}
\examples{
if (interactive()) {
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                  time_out = 300, engine = "gigwa", no_auth = TRUE)
  gigwa_set_db("Sorghum-JGI_v1")
  gigwa_set_project("Nelson_et_al_2011")
  gigwa_set_run("run1")
  marker_matrix <- gigwa_get_variants(max_missing = 0.2, 
                                      min_maf = 0.35, 
                                      samples = c("ind1", "ind3", "ind7"))
}

}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
