% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_germplasm_data}
\alias{get_germplasm_data}
\title{Retrieve Observations Data for a Specified Germplasm.}
\usage{
get_germplasm_data(germplasm_name = "")
}
\arguments{
\item{germplasm_name}{The name of the germplasm.}
}
\value{
A data frame containing all available observations data for the specified germplasm.
}
\description{
Retrieves all available observations data for the given germplasm in the current active crop.
This data is aggregated across all trials in the crop database.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()
  set_crop("wheat")
  germplasm_observations <- get_germplasm_data("Jabal")
  head(germplasm_observations)
}

}
\seealso{
\code{\link{login}}, \code{\link{set_crop}}, \code{\link{get_germplasm_attributes}}
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
