% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_url.R
\name{query_url}
\alias{query_url}
\title{PX-Web API query URL}
\usage{
query_url(
  url_or_tableid,
  ...,
  url_type = "ssb",
  use_index = FALSE,
  default_query = c(1, -2, -1)
)
}
\arguments{
\item{url_or_tableid}{A table id, a PxWebApi v2 URL to data or metadata, or metadata returned by
\code{\link[=meta_data]{meta_data()}} or \code{\link[=meta_frames]{meta_frames()}}.}

\item{...}{Specification of query for each variable. See ‘Details’ in \code{\link[=api_data]{api_data()}}.}

\item{url_type}{Currently two possibilities: "ssb" (Norwegian) or "ssb_en" (English).}

\item{use_index}{Logical. If TRUE, numeric values are matched against the \code{index} variable in
the metadata, which usually starts at 0. If FALSE (default), numeric values
are interpreted as row numbers in the metadata, using standard R indexing.
Negative values can be used to specify reversed row numbers.}

\item{default_query}{Specification for variables not included in \code{...}.
The default is \code{default_query = c(1, -2, -1)},
which selects the first and the two last codes listed in the metadata.
Use \code{default_query = TRUE}
and omit specifying individual variables to retrieve entire tables.}
}
\value{
A PxWeb API URL to data, with query parameters added according to the input.
}
\description{
PX-Web API query URL
}
\examples{

query_url(4861, 
          Region = FALSE, 
          ContentsCode = "Bosatte", 
          Tid = c(1, 5, -1), 
          url_type = "ssb_en")
          
          
query_url("https://data.ssb.no/api/pxwebapi/v2/tables/08991/data?lang=en",
          Fangst2 = FALSE,
          Elver = FALSE,
          ContentsCode = TRUE,  # same as "*"   
          Tid = "top(5)")       # same as 5i
          
          
          
query_url("https://data.ssb.no/api/pxwebapi/v2/tables/07459/data?lang=en",
          Region = FALSE,
          Kjonn = TRUE,
          Alder = list(codelist = "agg_TodeltGrupperingB", 
                       valueCodes = c("H17", "H18"),
                       outputValues = "aggregated"),
         ContentsCode = 1,
         Tid = 4i)

}
