% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-pcurve.R
\name{method.pcurve}
\alias{method.pcurve}
\title{pcurve (P-Curve) Method}
\usage{
\method{method}{pcurve}(method_name, data, settings)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes), sei (standard errors), and ni
(sample sizes wherever available, otherwise set to Inf)}

\item{settings}{List of method settings (see Details)}
}
\value{
Data frame with P-Curve results
}
\description{
Implements the p-Curve method which analyzes the distribution of p-values from significant studies to
assess whether the significant findings reflect true effects or QRP/publication bias.
The method also provides tests for the evidential value, lack of evidential value,
and p-hacking. See
\insertCite{simonsohn2014pcurve;textual}{PublicationBiasBenchmark} for details.

The current implementation does not provide a test against the null hypothsis of no effect
and does not produce confidence intervals of the estimate.
}
\details{
The following settings are implemented \describe{
\item{\code{"default"}}{no options}
}
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply pcurve method
result <- run_method("pcurve", data)
print(result)

}
\references{
\insertAllCited{}
}
