% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getter_functions.R
\name{instance}
\alias{instance}
\alias{instance.PubChemInstanceList}
\title{Retrieve Information for Requested Instances}
\usage{
instance(object, ...)

\method{instance}{PubChemInstanceList}(object, .which = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{'PubChemInstanceList'} returned from a PubChem request.}

\item{...}{Additional arguments passed to other methods. Currently, these have no effect.}

\item{.which}{A string specifying which instance's results to return. If NULL, the results of the first instance in
the \code{object} are returned. The default value is NULL.}
}
\description{
This function extracts the results of a PubChem instance from an \code{object}. It is designed to retrieve
information about a compound from a comprehensive list where multiple elements (such as assay, compound, etc.) are requested.
}
\examples{
\donttest{
compounds <- get_compounds(
  identifier = c("aspirin", "ibuprofen"),
  namespace = "name"
)

instance(compounds)  # Returns the results for "aspirin"
instance(compounds, "ibuprofen")
}
}
