% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_posteriors.R
\name{sample_distrib}
\alias{sample_distrib}
\title{Sample from a t-distribution}
\usage{
sample_distrib(posterior, nb_sample = 1000)
}
\arguments{
\item{posterior}{A tibble or data frame, detailing for each \code{Peptide}
and each \code{Group}, the value of the t-distribution parameters. The
expected format is typically a return from a posterior_mean() function.
Expected columns in the univariate case: \code{mu}, \code{lambda},
\code{alpha}, \code{beta}. Expected columns in the multivariate case:
\code{mu}, \code{lambda}, \code{Sigma}, \code{nu}.}

\item{nb_sample}{A number, indicating the number of samples generated for
each couple \code{Peptide}-\code{Group}.}
}
\value{
A tibble containing the \code{Peptide}, \code{Group} and
\code{Sample} columns. The samples of each \code{Peptide}-\code{Group}
couple provide an empirical t-distribution that can be used to compute and
display differences between groups.
}
\description{
Sample from a (possibly multivariate) t-distribution. This function can be
used to sample both from a prior or posterior, depending on the value of
parameters provided.
}
\examples{
TRUE
}
