% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileGLMM_preprocess.R
\name{profileGLMM_preprocess}
\alias{profileGLMM_preprocess}
\title{Preprocess the data from a list describing the profile LMM model}
\usage{
profileGLMM_preprocess(
  regType,
  covList,
  dataframe,
  nC,
  intercept = list(FE = TRUE, RE = TRUE, Lat = TRUE)
)
}
\arguments{
\item{regType}{A string, current possibilities: linear or probit}

\item{covList}{A list with fields:\itemize{
\item  FE fixed effect covariates names/index in dataframe
\item  RE random effect covariates names/index in dataframe
\item  Lat latent effect covariates names/index in dataframe
\item  Assign assignement variables list with fields:\itemize{
       \item  Cont Continuous variables names/index in dataframe
       \item  Cat Categorical variables names/index in dataframe
}
\item  REunit statistical unit of the RE colomn name/index
\item  Y outcome (Continuous)}}

\item{dataframe}{A dataframe containing outcome anf covariates}

\item{nC}{int: maximal number of cluster for the DP truncation}

\item{intercept}{(optionnal): A list with fields\itemize{
\item  RE bool indicating if FE have an intercept
\item  FE bool indicating if RE have an intercept
\item  Lat bool indicating if Latent have an intercept}}
}
\value{
An object of class \code{pglmm_data}. This is a list with\itemize{
\item  d dictionary with  [XFE,XRE,XLat,UCont,UCat,ZRE] design matrices
\item  [[params]] list of the parameters of the data\itemize{
                 \item  n int nb of obs
                 \item  qFE int, number of covariates of FE
                 \item  nRE int, number of stat units of RE
                 \item  qRE int, number of covariates of RE
                 \item  qLat int, number of covariates interacting with the
                                  latent clusters
                 \item  qUCont int, number of continuous clustering covariates
                 \item  qUCat int, number of categorical clustering covariates
                 \item  nC int, maximal number of clusters}
\item prior a list with all the specification of the default prior used
\item theta a list with a default set of parameters to start the chain, drawn from the prior
\item regType an int. Currently 0 for linear, 1 for probit}
}
\description{
Preprocess the data from a list describing the profile LMM model
}
\examples{
data("exposure_data")
exp_data = exposure_data$df
theta0 = exposure_data$theta0
covList = {}
covList$FE = c('X')
covList$RE = c('t')
covList$REunit = c('indiv')

covList$Lat = c('X')

covList$Assign$Cont = c('Exp1','Exp2')
covList$Assign$Cat = NULL

covList$Y = c('Y')
dataProfile = profileGLMM_preprocess(regType = 'linear',
                                     covList = covList,
                                     dataframe = exp_data,
                                     nC = 30,
                                     intercept = list(FE = TRUE, RE = FALSE, Lat = TRUE))
}
