% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funcs.R
\name{create_virtual_env}
\alias{create_virtual_env}
\title{Make a new virtual environment}
\usage{
create_virtual_env(virtualenv, version = NULL, verbose = TRUE)
}
\arguments{
\item{virtualenv}{Specify conda environment name}

\item{version}{Set path to specific version of python.}

\item{verbose}{TRUE or FALSE. When TRUE, shows python and conda configuration.
Default: TRUE}
}
\value{
None
}
\description{
This function creates a new virtual environment and initializes
the new virtual environment.
In doing so, this function sets your python version 
and one may specify a specific python version. This is useful
if you have multiple versions of python installed.
When making a new virtual environment, if the python version isn't set, then
your default one will be used.
}
\examples{
\dontrun{
create_virtual_env(version = "/usr/bin/python3", 
    virtualenv = "r-reticulate", 
    verbose = TRUE)
}
}
