% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recursive_ForecastErrors.R
\name{recursive_hstep_fast}
\alias{recursive_hstep_fast}
\title{Forecasting h-steps ahead using Recursive Least Squares Fast}
\usage{
recursive_hstep_fast(y, x, pi0, h)
}
\arguments{
\item{y}{an outcome series, which should be numeric and one dimensional.}

\item{x}{a predictor matrix (intercept would be added automatically).}

\item{pi0}{Fraction of the sample, which should be within 0 and 1.}

\item{h}{Number of steps ahead to predict, which should be a positive integer.}
}
\value{
Series of residuals estimated
}
\description{
Consider the following LS-fitted Model with intercept:
y_(t+h) = beta_0 + x_(jt) * beta + u_(t+h)
which is used to generate out-of-sample forecasts of y, h-steps ahead (h=1,2,3,. . . ).
Notes: (1) first estimation window is (1,...,k0) and last window is 
(1,....,n-h) for k0 = round(n*pi0). First forecast is yhat(k0+h|k0)
and last forecast is yhat(n|n-h). There are a total of (n-h-k0+1)
forecasts and corresponding forecast errors. (2) this fast version of the
recursive least squares algorithm uses the Sherman-Morrison matrix
formula to avoid matrix inversions at each recursion. (3) x_(jt) is the j^th predictor in x (j^th column).
}
\details{
recursive_hstep_fast is the fast version that avoids the recursive calculation of inverse of the matrix using Sherman-Morrison formula.
}
\examples{
x<- rnorm(15);
y<- x+rnorm(15);
temp1 <- recursive_hstep_fast(y,x,pi0=0.5,h=1);
}
